package io.transwarp.report.html.cluster;

import java.util.List;

import io.transwarp.common.bean.service.RoleBean;
import io.transwarp.common.bean.service.ServiceBean;
import io.transwarp.report.html.AbstractContentItem;

public class ServiceContentItemImpl extends AbstractContentItem {
	
	private final ServiceBean[] services;

	public ServiceContentItemImpl(ServiceBean[] services) {
		super();
		this.services = services;
	}
	
	@Override
	public void buildHtml(String itemName_EN, String itemName_CN) {
		result.add(String.format("<div id=\"%s\"> <h3 class=\"atomItem\">%s</h3> <table class=\"showtable\">\n", itemName_EN, itemName_CN));
		result.add("  <tr> <th width=\"50%%\">服务名称</th> <th width=\"50%%\">服务状态</th>\n");
		for (ServiceBean service : services) {
			String servicename = service.getName();
			String serviceHealth = service.getHealth();
			StringBuffer status = new StringBuffer();
			if (serviceHealth.matches("HEALTHY\\S*")) {
				status.append(serviceHealth);
			} else {
				warning = true;
				risk += 1;
				Boolean hasInfo = false;
				List<RoleBean> roles = service.getRoles();
				for (RoleBean role : roles) {
					String health = role.getHealth();
					if ("UNKNOWN".equals(health) || "".equals(health)) {
						continue;
					} else if ("DOWN".equals(health) || "WARNING".equals(health)) {
						if (hasInfo) {
							status.append("<br>");
						}
						hasInfo = true;
						status.append(role.getName()).append(" is ").append(health);
					}
				}
			}
			result.add(String.format("  <tr> <td width=\"50%%\">%s</td> <td width=\"50%%\">%s</td>\n", servicename, status.toString()));
		}
		result.add("</table> </div>\n");
	}

}
