package io.transwarp.report.html.cluster;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.util.UtilTools;
import io.transwarp.report.html.AbstractContentItem;

public class ShardContentItemImpl extends AbstractContentItem {
	
	private final Map<String, Map<String, Long>> searchServices;
	private final Map<String, Long> totalSizes;
	private Long totalLimit;
	
	public ShardContentItemImpl(Map<String, Map<String, Long>> searchServices) {
		super();
		this.searchServices = searchServices;
		totalSizes = new HashMap<String, Long>();
		totalLimit = Long.valueOf(GlobalArgs.prop_rules.getProperty("table.es.shard.totalSize.limit", "8192"))*1024*1024*1024;
	}

	@Override
	public void buildHtml(String itemName_EN, String itemName_CN) {
		getTotalSizes();
		result.add(String.format("<div id=\"%s\"> <h3 class=\"atomItem\">%s</h3> <table class=\"showtable\">\n", itemName_EN, itemName_CN));
		result.add("  <tr> <th width=\"50%%\">节点</th> <th width=\"50%%\">shard总大小</th> </tr>\n");
		for (Entry<String, Long> entry : totalSizes.entrySet()) {
			String hostname = entry.getKey();
			Long value = entry.getValue();
			if (value > totalLimit) {
				warning = true;
				risk += 1;
			}
			result.add(String.format("  <tr> <td>%s</td> <td>%s</td> </tr>\n", hostname, UtilTools.getCarrySize(value)));
		}
		if (totalSizes.size() == 0) {
			result.add("  <tr> <td colspan=\"2\">暂时没有shard信息</td> </tr>\n");
		}
		result.add("</table> </div>\n");
	}
	
	private void getTotalSizes() {
		for (Entry<String, Map<String, Long>> entry : searchServices.entrySet()) {
			Map<String, Long> shardSizes = entry.getValue();
			for (Entry<String, Long> shardEntry : shardSizes.entrySet()) {
				String hostname = shardEntry.getKey();
				Long size = shardEntry.getValue();
				Long value = totalSizes.get(hostname);
				if (value == null) {
					totalSizes.put(hostname, size);
				} else {
					totalSizes.put(hostname, value + size);
				}
			}
		}
	}

}
