package io.transwarp.report.html.hdfs;

import java.util.List;

import io.transwarp.report.html.AbstractContentItem;

public class HdfsInfoContentItemImpl extends AbstractContentItem {
	
	private final List<String[]> values;
	
	public HdfsInfoContentItemImpl(List<String[]> values, Boolean warning) {
		super();
		super.warning = warning;
		this.values = values;
		if (warning) {
			risk += 1;
		}
	}

	@Override
	public void buildHtml(String itemName_EN, String itemName_CN) {
		result.add(String.format("<div id=\"%s\"> <h3 class=\"atomItem\">%s</h3> <table class=\"showtable\">\n", itemName_EN, itemName_CN));
		for (String[] line : values) {
			StringBuffer buf = new StringBuffer();
			int width = 100/line.length;
			String widthString = String.format(" width=\"%s%%\"", width);
			for (String item : line) {
				buf.append(" <td ").append(widthString).append(">").append(item).append("</td> ");
			}
			result.add(String.format("  <tr>%s</tr>\n", buf.toString()));
		}
		result.add("</table> </div>\n");
	}

}
