package io.transwarp.report.html.hdfs;

import java.util.List;

import io.transwarp.report.html.AbstractContentItem;

public class HdfsSpaceContentItemImpl extends AbstractContentItem {
	
	private final List<String[]> hdfsSpace;
	
	public HdfsSpaceContentItemImpl(List<String[]> hdfsSpace) {
		super();
		this.hdfsSpace = hdfsSpace;
	}

	@Override
	public void buildHtml(String itemName_EN, String itemName_CN) {
		result.add(String.format("<div id=\"%s\"> <h3 class=\"atomItem\">%s</h3> <table class=\"showtable\">\n", itemName_EN, itemName_CN));
		result.add("  <tr> <th width=\"25%%\">目录</th> <th width=\"25%%\">总大小</th> <th width=\"25%%\">小文件个数</th> <th width=\"25%%\">小文件占比</th> </tr>\n");
		int number = hdfsSpace.size();
		if (number > 1) {
			warning = true;
			risk += 1;
		}
		for (int i = 0; i < number; i++) {
			StringBuffer buf = new StringBuffer();
			String[] line = hdfsSpace.get(i);
			for (String item : line) {
				buf.append(" <td>").append(item).append("</td> ");
			}
			result.add(String.format("  <tr>%s</tr>\n", buf.toString()));
		}
		result.add("</table> </div>\n");
	}

}
