package io.transwarp.report.html.hdfs;

import io.transwarp.common.bean.InspectionData;
import io.transwarp.report.comparison.ComparisonResult;
import io.transwarp.report.html.AbstractSummaryContent;
import io.transwarp.report.html.AbstractContentItem;

public class HdfsSummaryContentImpl extends AbstractSummaryContent {

	public HdfsSummaryContentImpl(InspectionData data, ComparisonResult comparisonResult) {
		super(data, comparisonResult);
	}

	@Override
	public void initCheckItems() {
		checkItems.add("文件空间检查");
		checkItems.add("数据节点使用检查");
		checkItems.add("文件块检查");
		
	}

	@Override
	public AbstractContentItem createItem(String itemName) {
		if (itemName.equals("文件空间检查")) {
			return new HdfsSpaceContentItemImpl(comparisonResult.HDFS.hdfsSpace);
		} else if (itemName.equals("数据节点使用检查")) {
			return new HdfsInfoContentItemImpl(comparisonResult.HDFS.report, comparisonResult.HDFS.reportWarn);
		} else if (itemName.equals("文件块检查")) {
			return new HdfsInfoContentItemImpl(comparisonResult.HDFS.fsck, comparisonResult.HDFS.fsckWarn);
		}
		return null;
	}

}
