package io.transwarp.report.html.resource;

import java.util.List;

import io.transwarp.report.html.AbstractContentItem;

public class ExecutorContentItemImpl extends AbstractContentItem {
	
	private final List<String[]> executorInfos;
	
	public ExecutorContentItemImpl(List<String[]> executorInfos, Boolean warning) {
		super();
		this.executorInfos = executorInfos;
		super.warning = warning;
	}

	@Override
	public void buildHtml(String itemName_EN, String itemName_CN) {
		result.add(String.format("<div id=\"%s\"> <h3 class=\"atomItem\">%s</h3> <table class=\"showtable\">\n", itemName_EN, itemName_CN));
		result.add("  <tr> <th>服务角色</th> <th>节点</th> <th>使用的core数</th> <th>节点总core数</th> <th>使用core数占比</th> <th>使用的内存</th> <th>节点总内存</th> <th>使用内存占比</th> </tr>\n");
		for (String[] line : executorInfos) {
			StringBuffer buf = new StringBuffer();
			for (String item : line) {
				buf.append(" <td>").append(item).append("</td> ");
			}
			result.add(String.format("  <tr> %s </tr>\n", buf.toString()));
		}
		if (executorInfos.size() == 0) {
			result.add(String.format("  <tr> <td colspan=\"8\">%s暂未找到executor信息</td> </tr>\n", itemName_CN));
		}
		result.add("</table> </div>\n");
	}

}
