package io.transwarp.report.html.resource;

import io.transwarp.common.bean.InspectionData;
import io.transwarp.report.comparison.ComparisonResult;
import io.transwarp.report.html.AbstractContentItem;
import io.transwarp.report.html.AbstractSummaryContent;

public class ResourceSummaryContentImpl extends AbstractSummaryContent {
	
	public ResourceSummaryContentImpl(InspectionData data, ComparisonResult comparisonResult) {
		super(data, comparisonResult);
	}

	@Override
	public void initCheckItems() {
		checkItems.add("executor资源使用检查");
		
	}

	@Override
	public AbstractContentItem createItem(String itemName) {
		if (itemName.equals("executor资源使用检查")) {
			return new ExecutorContentItemImpl(comparisonResult.SERVICE.executorInfos, comparisonResult.SERVICE.executorWarn);
		}
		return null;
	}

}
