package io.transwarp.report.html.table;

import java.util.List;

import io.transwarp.report.html.AbstractContentItem;

public class TableContentItemImpl extends AbstractContentItem {
	
	private final List<String[]> values;
	
	public TableContentItemImpl(List<String[]> values) {
		super();
		this.values = values;
	}

	@Override
	public void buildHtml(String itemName_EN, String itemName_CN) {
		result.add(String.format("<div id=\"%s\"> <h3 class=\"atomItem\">%s</h3> <table class=\"showtable\">\n", itemName_EN, itemName_CN));
		result.add("  <tr> <th width=\"33%%\">表</th> <th width=\"33%%\">告警</th> <th width=\"33%%\">描述</th>");
		for (String[] line : values) {
			StringBuffer buf = new StringBuffer();
			for (String item : line) {
				buf.append(" <td width=\"33%%\">").append(item).append("</td> ");
			}
			result.add(String.format("  <tr>%s</tr>\n", buf.toString()));
		}
		if (values.size() == 0) {
			result.add(String.format("  <tr> <td colspan=\"3\">%s暂无告警信息</td> </tr>\n", itemName_CN));
		} else {
			risk += 1;
			warning = true;
		}
		result.add("</table> </div>\n");
	}

}
