package io.transwarp.report.html.table;

import io.transwarp.common.bean.InspectionData;
import io.transwarp.report.comparison.ComparisonResult;
import io.transwarp.report.html.AbstractSummaryContent;
import io.transwarp.report.html.AbstractContentItem;

public class TableSummaryContentImpl extends AbstractSummaryContent {

	public TableSummaryContentImpl(InspectionData data, ComparisonResult comparisonResult) {
		super(data, comparisonResult);
	}
	
	@Override
	public void initCheckItems() {
		checkItems.add("TEXT表");
		checkItems.add("ORC表");
		checkItems.add("HBase表");
		checkItems.add("ES表");
	}

	@Override
	public AbstractContentItem createItem(String itemName) {
		if (itemName.equals("TEXT表")) {
			return new TableContentItemImpl(comparisonResult.TABLE.textErrorInfos);
		} else if (itemName.equals("ORC表")) {
			return new TableContentItemImpl(comparisonResult.TABLE.orcErrorInfos);
		} else if (itemName.equals("HBase表")) {
			return new TableContentItemImpl(comparisonResult.TABLE.hbaseErrorInfos);
		} else if (itemName.equals("ES表")) {
			return new TableContentItemImpl(comparisonResult.TABLE.esErrorInfos);
		}
		return null;
	}

}
