package io.transwarp.report.xls;

import java.util.Map.Entry;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.TimeStatistics;
import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class CostTimeXlsReportImpl implements XlsReport {
	
	private final WritableSheet sheet;
	
	public CostTimeXlsReportImpl(final WritableWorkbook workbook,
			final ReportEnum checkItem) {
		this.sheet = workbook.createSheet("costTime", checkItem.ordinal());
	}

	@Override
	public void writeSheet() throws Exception {
		int row = 0;
		sheet.addCell(new Label(1, row, "checkItem", CELL_BOLD));
		sheet.addCell(new Label(2, row, "cost time", CELL_BOLD));
		row += 1;
		for (Entry<String, TimeStatistics> entry : GlobalArgs.timeStatisticses.entrySet()) {
			sheet.addCell(new Label(1, row, entry.getKey(), CELL_THIN));
			sheet.addCell(new Label(2, row, entry.getValue().getCostTime(), CELL_THIN));
			row += 1;
		}
		
	}

}
