package io.transwarp.report.xls;

import io.transwarp.common.GlobalArgs;
import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class ErrorXlsReportImpl implements XlsReport {
	
	private final WritableSheet sheet;
	
	public ErrorXlsReportImpl(final WritableWorkbook workbook,
			final ReportEnum checkItem) {
		this.sheet = workbook.createSheet("check_error", checkItem.ordinal());
	}

	@Override
	public void writeSheet() throws Exception {
		int beginRow = 1;
		beginRow = writeTitle(beginRow);
		beginRow = writeErrorInfo(beginRow);
		sheet.setColumnView(1, 40);
		sheet.setColumnView(2, 40);
	}
	
	private int writeTitle(int beginRow) throws Exception {
		sheet.addCell(new Label(1, beginRow, "error Item", CELL_BOLD));
		sheet.addCell(new Label(2, beginRow, "error message", CELL_BOLD));
		return beginRow + 1;
	}
	
	private int writeErrorInfo(int beginRow) throws Exception {
		for (String errorInfo : GlobalArgs.ERROR_INFO) {
			String[] items = errorInfo.split(" \\| ");
			int column = 1;
			for (String item : items) {
				sheet.addCell(new Label(column++, beginRow, item, CELL_THIN));
			}
			beginRow += 1;
		}
		return beginRow;
	}
}
