package io.transwarp.report.xls;

import jxl.format.Alignment;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.WritableCellFormat;
import io.transwarp.common.util.WorkbookUtilTools;

public interface XlsReport {
	
	WritableCellFormat CELL_BOLD = WorkbookUtilTools.getCellFormat(12, "BOLD", Alignment.LEFT, VerticalAlignment.CENTRE, Colour.BLACK, null);
	WritableCellFormat CELL_THIN = WorkbookUtilTools.getCellFormat(12, "", Alignment.LEFT, VerticalAlignment.CENTRE, Colour.BLACK, null);
	WritableCellFormat CELL_EMPHASIS = WorkbookUtilTools.getCellFormat(12, "", Alignment.LEFT, VerticalAlignment.CENTRE, Colour.BLACK, Colour.YELLOW);
	WritableCellFormat CELL_ERROR = WorkbookUtilTools.getCellFormat(12, "", Alignment.LEFT, VerticalAlignment.CENTRE, Colour.RED, null);

	void writeSheet() throws Exception;
}
