package io.transwarp.service.comparison;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.LicenseBean;
import io.transwarp.common.bean.LicenseBean.ComponentBean;
import io.transwarp.report.comparison.Comparison;

public class LicenseComparisonImpl implements Comparison {
	
	private final ComparisonResultOfService comparisonResult;
	private final LicenseBean license;
	private final SimpleDateFormat dateFormat;
	private boolean warning;
	private Long licenseTimeLimit;

	public LicenseComparisonImpl(final ComparisonResultOfService comparisonResult,
			LicenseBean license) {
		this.comparisonResult = comparisonResult;
		this.license = license;
		if (GlobalArgs.version.startsWith("4")) {
			dateFormat = new SimpleDateFormat("MMM d, yyyy", Locale.ENGLISH);
		} else {
			dateFormat = new SimpleDateFormat("yyyy-MM-dd");
		}
		this.warning = false;
		this.licenseTimeLimit = Long.valueOf(GlobalArgs.prop_rules.getProperty("cluster.license.date.limit", "10"))*24*60*60*1000;
	}
	
	@Override
	public void comparison() throws Exception {
		List<String[]> componentResult = new ArrayList<String[]>();
		String[] title = new String[3];
		title[0] = "compType";
		title[1] = "licenseType";
		title[2] = "expiredDate";
		componentResult.add(title);
		List<ComponentBean> components = license.getComponents();
		for (ComponentBean component : components) {
			String[] items = new String[3];
			items[0] = component.getCompType();
			items[1] = component.getLicenseType();
			items[2] = component.getExpiredDate();
			checkDate(items[2]);
			componentResult.add(items);
		}
		comparisonResult.licenseDate = componentResult;
		comparisonResult.licenseWarn = warning;
	}
	
	private void checkDate(String expiredDate) {
		Date date = null;
		try {
			date = dateFormat.parse(expiredDate);
			long dateDiff = date.getTime() - System.currentTimeMillis();
			if (dateDiff < licenseTimeLimit) {
				warning = true;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
}
