package io.transwarp.service.comparison;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.ClusterInfo;
import io.transwarp.report.comparison.Comparison;
import io.transwarp.report.comparison.ComparisonResult;

public class ServiceComparisonImpl implements Comparison {
	
	private final ComparisonResult comparisonResult;
	private final ClusterInfo clusterInfo;
	private final String[] checkItems = new String[]{"license", "kafka", "executor"};

	public ServiceComparisonImpl(final ComparisonResult comparisonResult,
			final ClusterInfo clusterInfo) {
		this.comparisonResult = comparisonResult;
		this.clusterInfo = clusterInfo;
	}
	
	@Override
	public void comparison() throws Exception {
		Comparison comparison = null;
		for (String checkItem : checkItems) {
			comparison = buildComparison(checkItem);
			if (comparison != null) {
				try {
					comparison.comparison();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
	}
	
	private Comparison buildComparison(String checkItem) {
		if (checkItem.equals("license")) {
			return new LicenseComparisonImpl(comparisonResult.SERVICE, clusterInfo.getLicense());
		} else if (checkItem.equals("kafka")) {
			return GlobalArgs.checkSelect.isServiceCheckKafka() ? new KafkaComparisonImpl(comparisonResult.SERVICE, clusterInfo.getKafkaTopicMaps()) : null;
		} else if (checkItem.equals("executor")) {
			return new ExecutorComparisonImpl(comparisonResult.SERVICE, clusterInfo.getServices());
		}
		throw new RuntimeException("no find this check item : " + checkItem);
	}
}
