package io.transwarp.service.config.servlet;

import java.util.ArrayList;
import java.util.List;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.common.bean.service.RoleBean;
import io.transwarp.common.bean.service.ServiceBean;
import io.transwarp.common.util.AbstractRunnable;
import io.transwarp.common.util.ExecShell;

public class ExecutorCheckRunnable extends AbstractRunnable {
	
	private static final String QUERY_ACTIVE_EXECUTOR_4x = "ps -ef | grep Executor | grep -v grep | grep INCEPTOR_CONF_DIR | grep %s | wc -l";
	private static final String QUERY_ACTIVE_EXECUTOR_5x = "sudo docker ps | grep INCEPTOR_EXE | grep %s | wc -l";
	
	private final ServiceBean service;
	
	private String sid;
	private List<NodeBean> workerNodes;
	
	public ExecutorCheckRunnable(final ServiceBean service) {
		this.service = service;
		this.sid = service.getSid();
		this.workerNodes = new ArrayList<NodeBean>();
	}
	
	@Override
	public void startCheck() throws Exception {
		if (GlobalArgs.version.startsWith("4")) {
			getWorkerNodes("INCEPTOR_WORKER");
			getActiveExecutor(String.format(QUERY_ACTIVE_EXECUTOR_4x, sid));
		} else {
			getWorkerNodes("INCEPTOR_EXECUTOR");
			getActiveExecutor(String.format(QUERY_ACTIVE_EXECUTOR_5x, sid));
		}		
	}
	
	@Override
	public void dealWithError(Exception e) {
		GlobalArgs.ERROR_INFO.add(String.format("check active executor number on service [%s] is faild | %s", service.getName(), e.getMessage()));
		e.printStackTrace();
	}
	
	@Override
	public void closeThread() {
		
	}
	
	private void getWorkerNodes(String workNode) throws Exception {
		List<RoleBean> roles = service.getRoles();
		for (RoleBean role : roles) {
			String roleType = role.getRoleType();
			if (roleType.equals(workNode)) {
				workerNodes.add(role.getNode());
			}
		}
	}
	
	private void getActiveExecutor(String cmd) throws Exception {
		for (NodeBean node : workerNodes) {
			String ipAddress = node.getIpAddress();
			String result = ExecShell.exec(ipAddress, cmd);
			int number = Integer.valueOf(result.trim());
			service.addActiveExecutor(node.getHostName(), number);
		}
	}
}
