package io.transwarp.service.config.servlet;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.ReadXmlUtil;
import io.transwarp.common.bean.service.ConfigBean;
import io.transwarp.common.bean.service.RoleBean;
import io.transwarp.common.util.AbstractRunnable;
import io.transwarp.common.util.UtilTools;

public class ResourceCheckRunnable extends AbstractRunnable {
	
	private final Logger log = LoggerFactory.getLogger(ResourceCheckRunnable.class);
	private final String serviceType;
	private final RoleBean role;
	private final ConfigBean config;
	private final ReadXmlUtil prop_service_check;
	
	public ResourceCheckRunnable(final String serviceType, 
			final RoleBean role,
			final ConfigBean config,
			final ReadXmlUtil prop_service_check) {
		this.serviceType = serviceType;
		this.role = role;
		this.config = config;
		this.prop_service_check = prop_service_check;
	}
	
	@Override
	public void startCheck() throws Exception {
		log.info("begin check resource used of service role [{}]", role.getName());
		String ipAddress = role.getNode().getIpAddress();
		String[] resourceConfigs = getResourceConfigs();
		if (resourceConfigs == null) {
			role.setResource("");
			return;
		}
		StringBuffer resource = new StringBuffer();
		for (String resourceConfig : resourceConfigs) {
			String[] items = resourceConfig.split(":");
			Map<String, String> fileValue = config.getConfigFile(ipAddress, items[1]);
			String value = fileValue.get(items[2]);
			if (value == null || value.equals("")) {
				continue;
			}
			if (items[0].equals("memory") || items[0].equals("resource-memory")) {
				value = getMemoryValue(value);
				value += value.equals("") ? "" : " MB";
			}
			resource.append(",").append(items[0]).append(": ").append(value);
		}
		role.setResource(resource.toString());
	}

	@Override
	public void dealWithError(Exception e) {
		String errorMessage = String.format("resource check of service role [%s.%s] is faild | %s", serviceType, role.getRoleType(), e.getMessage());
		GlobalArgs.ERROR_INFO.add(errorMessage);
		log.error(errorMessage);
		e.printStackTrace();		
	}
	
	@Override
	public void closeThread() {
		log.info("check resource used of service role [{}] is completed", role.getName());
	}
	
	private String[] getResourceConfigs() {
		String topic = serviceType + ":" + role.getRoleType();
		String item = prop_service_check.getProperty(topic, "");
		if (item.equals("")) {
			log.warn("no find config of this service role : {}", topic);
			return null;
		}
		return item.split(";");
	}
	
	private String getMemoryValue(final String value) {
		String[] items = value.split(" ");
		if (items.length == 1) {
			return UtilTools.numberFormat(value).replaceAll("-", "");
		} else {
			for (String item : items) {
				if (item.indexOf("-Xmx") != -1) {
					return UtilTools.numberFormat(item).replaceAll("-", "");
				}
			}
		}
		return "";
	}
	
}
