package io.transwarp.service.kafka.servlet;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.node.NodeBean;
import io.transwarp.common.bean.service.KafkaPartitionBean;
import io.transwarp.common.bean.service.KafkaTopicBean;
import io.transwarp.common.bean.service.RoleBean;
import io.transwarp.common.bean.service.ServiceBean;
import io.transwarp.common.util.AbstractRunnable;
import io.transwarp.inspection.CheckItemEnum;

import java.util.List;
import java.util.Map.Entry;
import java.util.Properties;

import org.apache.kafka.common.security.JaasUtils;

import scala.Option;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import kafka.admin.AdminUtils;
import kafka.server.ConfigType;
import kafka.utils.ZkUtils;

public class KafkaCheckRunnable extends AbstractRunnable {

	private final ServiceBean zookeeper;
	private final java.util.Map<String, KafkaTopicBean> topicInfos;
	
	public KafkaCheckRunnable(final ServiceBean zookeeper,
			final java.util.Map<String, KafkaTopicBean> topicInfos) {
		this.zookeeper = zookeeper;
		this.topicInfos = topicInfos;
	}
	
	@Override
	public void startCheck() throws Exception {
		String ipAddress = getZkIpAddress();
		if (ipAddress == null) {
			throw new Exception("no find zookeeper client ipAddress");
		}
		getTopicInfo(ipAddress);		
	}
	
	@Override
	public void dealWithError(Exception e) {
		GlobalArgs.ERROR_INFO.add(String.format("check kafka topic faild | " + e.getMessage()));
		e.printStackTrace();		
	}
	
	@Override
	public void closeThread() {
		GlobalArgs.timeStatisticses.get(CheckItemEnum.SERVICE.name()).setEndTime();
	}
	
	private String getZkIpAddress() {
		List<RoleBean> roles = zookeeper.getRoles();
		if (roles.size() == 0) {
			return null;
		}
		for (RoleBean role : roles) {
			if (role.getHealth().equals("HEALTHY")) {
				NodeBean node = role.getNode();
				String ipAddress = node.getIpAddress();
				return ipAddress;
			}
		}	
		return null;
	}
	
	private void getTopicInfo(final String ipAddress) throws Exception {
		ZkUtils zkUtils = ZkUtils.apply(ipAddress, 30000, 30000, JaasUtils.isZkSecurityEnabled());
		Seq<String> topics = zkUtils.getAllTopics();
		Map<String, Map<Object, Seq<Object>>> partitionAssignments = zkUtils.getPartitionAssignmentForTopics(topics);
		Set<Object> liveBrokers = zkUtils.getAllBrokersInCluster().toSet();
		Iterator<String> topicIt = topics.iterator();
		while (topicIt.hasNext()) {
			String topic = topicIt.next();
			KafkaTopicBean kafkaTopic = new KafkaTopicBean(topic);
			Map<Object, Seq<Object>> topicPartitionAssignment = partitionAssignments.get(topic).get();
			kafkaTopic.setReplicationFactor(topicPartitionAssignment.head()._2.size());
			Properties configs = AdminUtils.fetchEntityConfig(zkUtils, ConfigType.Topic(), topic);
			StringBuffer configBuf = new StringBuffer();
			for (Entry<Object, Object> entry : configs.entrySet()) {
				configBuf.append(entry.getKey()).append(" = ").append(entry.getValue()).append(", ");
			}
			if (configBuf.length() > 0) {
				kafkaTopic.setConfigs(configBuf.substring(0, configBuf.length() - 1));
			}
			Iterator<Object> partitionIt = topicPartitionAssignment.keysIterator();
			while (partitionIt.hasNext()) {
				Object partitionId = partitionIt.next();
				int partitionIdInInteger = Integer.valueOf(partitionId.toString());
				Seq<Object> assignedReplicas = topicPartitionAssignment.get(partitionId).get();
				Seq<Object> inSyncReplicas = zkUtils.getInSyncReplicasForPartition(topic, partitionIdInInteger);
				Option<Object> leader = zkUtils.getLeaderForPartition(topic, partitionIdInInteger);
				if (inSyncReplicas.size() < assignedReplicas.size() || leader == null || !liveBrokers.contains(leader.get())) {
					kafkaTopic.addPartition(new KafkaPartitionBean(partitionId, (leader.isDefined() ? leader.get() : "none"),
							assignedReplicas.mkString(","),	inSyncReplicas.mkString(",")));
				}
			}
			this.topicInfos.put(topic, kafkaTopic);
		}
	}
}
