package io.transwarp.service.process.report;

import java.util.Map;
import java.util.Map.Entry;
import java.util.Vector;

import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import io.transwarp.common.bean.service.ProcessBean;
import io.transwarp.common.bean.service.ServiceBean;
import io.transwarp.report.xls.ReportEnum;
import io.transwarp.report.xls.XlsReport;

public class ProcessXlsReportImpl implements XlsReport {
	
	private final WritableSheet sheet;
	private final Map<String, ServiceBean> services;
	
	private int maxColumn;
	
	public ProcessXlsReportImpl(final WritableWorkbook workbook,
			final ReportEnum checkItem,
			final Map<String, ServiceBean> services) {
		this.sheet = workbook.createSheet("process", checkItem.ordinal());
		this.services = services;
		this.maxColumn = 0;
	}

	@Override
	public void writeSheet() throws Exception {
		int beginRow = 0;
		for (Entry<String, ServiceBean> entry : services.entrySet()) {
			ServiceBean service = entry.getValue();
			Vector<ProcessBean> processes = service.getProcesses();
			for (ProcessBean process : processes) {
				beginRow = writeProcessInSheet(beginRow, process);
			}
		}
		for (int i = 1; i < maxColumn; i++) {
			sheet.setColumnView(i, 20);
		}
	}
	
	private int writeProcessInSheet(int beginRow, final ProcessBean process) throws Exception {
		String servicename = process.getServicename();
		String roleType = process.getRoleType();
		Map<String, String> jvmInfos = process.getJvmInfos();
		if (jvmInfos.size() == 0) {
			return beginRow;
		}
		sheet.addCell(new Label(0, beginRow++, String.format("service [%s], roleType [%s]", servicename, roleType), CELL_BOLD));
		for (Entry<String, String> entry : jvmInfos.entrySet()) {
			String itemName = entry.getKey();
			String value = entry.getValue();
			if (value.trim().equals("")) {
				continue;
			}
			String[] lines = value.split("\n");
			sheet.addCell(new Label(1, beginRow++, itemName, CELL_BOLD));
			for (String line : lines) {
				String[] items = line.split("\\|");
				int column = 2;
				for (String item : items) {
					sheet.addCell(new Label(column++, beginRow, item, CELL_THIN));
				}
				this.maxColumn = Math.max(maxColumn, column);
				beginRow += 1;
			}
		}
		return beginRow + 1;
	}
}
