package io.transwarp.service.process.servlet;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.transwarp.common.ReadXmlUtil;
import io.transwarp.common.util.ExecShell;

public class GcCheckProcessCheck  {

	private final Logger log = LoggerFactory.getLogger(GcCheckProcessCheck.class);
	private ReadXmlUtil prop_process_check;
	private String dockerHead;
	private String processID;
	private String ipAddress;
	private int time;
	// 执行时间间隔/s
	private final int period = 5;
	
	private String jinfoCMSResult;
	private ArrayList<Map<String,String>> jstatResults;
	private String compareResult;
	private StringBuffer jstatStringResults = new StringBuffer();
	 
	public String getJstatStringResults() {
		return jstatStringResults.toString();
	}

	public String getJinfoCMSResult() {
		return jinfoCMSResult;
	}

	public void setJinfoCMSResult(String jinfoCMSResult) {
		this.jinfoCMSResult = jinfoCMSResult;
	}

	public ArrayList<Map<String,String>> getJstatResults() {
		return jstatResults;
	}

	public void setJstatResults(ArrayList<Map<String,String>> jstatResults) {
		this.jstatResults = jstatResults;
	}

	public String getCompareResult() {
		return compareResult;
	}

	public void setCompareResult(String compareResult) {
		this.compareResult = compareResult;
	}
	
	public GcCheckProcessCheck(ReadXmlUtil prop_process_check, String dockerHead, String processID,  String ipAddress) {
		this.prop_process_check = prop_process_check;
		this.dockerHead = dockerHead;
		this.processID = processID;
		this.ipAddress = ipAddress;
		this.time = Integer.parseInt(prop_process_check.getProperty("process.gcCheck.command", "1"));
		run();
	}

	public void run() {
		
		//获取配置中jinfo与jstat执行command
		String jinfoCommand = dockerHead + prop_process_check.getProperty("process.jinfo.command", "").replaceAll("\\(id\\)", processID);
		String jstatCommand = dockerHead + prop_process_check.getProperty("process.jstat.command", "").replaceAll("\\(id\\)", processID);
		
		String JInfoCMSResult = getCMSInitiatingOccupancyFraction(jinfoCommand);
		setJinfoCMSResult(JInfoCMSResult);
		
		ArrayList<Map<String,String>> JstatResults = new ArrayList<Map<String,String>>();
		//执行次数
		int times = time * 60 / period;
		for(int i = 1; i < times; i++){
			 JstatResults.add(getJstatGcutil(jstatCommand));
			 try {
				Thread.sleep(period * 1000);
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		
		setJstatResults(JstatResults);
		
		//从所有Jstat结果中获取老年代的信息
		ArrayList<String> JstatOldResults = getJstatGcutilOld(JstatResults);	
		setCompareResult(compare(JInfoCMSResult,JstatOldResults));				
	}

	private ArrayList<String> getJstatGcutilOld(ArrayList<Map<String, String>> jstatResults) {
		 ArrayList<String> JstatOldResults = new ArrayList<String>();
		for(Map<String, String> jstatResult : jstatResults){
			 for(Entry<String, String> entry : jstatResult.entrySet()){
				if("O".equals(entry.getKey())){
					JstatOldResults.add(entry.getValue());
				}
			}
		}
		return JstatOldResults;
	}

	private String getCMSInitiatingOccupancyFraction(String jinfoCommand) {
		StringBuffer jinfoCMSResult = new StringBuffer();
		log.info(ipAddress +":"+ jinfoCommand);
		String cmdResult = ExecShell.exec(ipAddress, jinfoCommand);
		String[] lines = cmdResult.split("\n");
		for (String line : lines) {
			//获取-XX:CMSInitiatingOccupancyFraction值
	        if (line.startsWith("-agentpath")) {
				String[] items = line.split("\\s+");
				for (String item : items) {
					if (item.startsWith("-XX:CMSInitiatingOccupancyFraction")) {
						jinfoCMSResult.append(item);
					}
				}
			}
		}
		return jinfoCMSResult.toString().trim();
	}
	
	private Map<String,String> getJstatGcutil(String jstatCommand) {

		//获取jstat信息
		Map<String,String> jstatMap = new HashMap<String,String>();
		
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String runTime = dateFormat.format(System.currentTimeMillis());
		
		String cmdResult = ExecShell.exec(ipAddress, jstatCommand);
		
		//解析cmdResult
		String[] lines = cmdResult.split("\n");
		String[] newLines = new String[2];
		
		//jstat -gcutil 只有两行结果
		newLines[0] = lines[0].trim().replaceAll("\\s+", "|");
		newLines[1] = lines[1].trim().replaceAll("\\s+", "|");

		if(jstatStringResults.length() == 0 ){
		   jstatStringResults.append(newLines[0]).append("\n");
		}
		jstatStringResults.append(runTime+"|"+newLines[1]).append("\n");
		
		String[] key = newLines[0].split("\\|");
		String[] value = newLines[1].split("\\|");

		for(int i = 0;i < key.length;i++){
			jstatMap.put(key[i], value[i]);
		}       	
		return jstatMap;
	}

	private String compare(String jInfoResult, ArrayList<String> JstatOldResults) {
		String compareResult = "gc check result return";
		//do compare
//		System.out.println("jInfoResult="+jInfoResult);
//		System.out.println("JstatOldResults=");
//		for(String JstatOldResult : JstatOldResults){
//			System.out.println(JstatOldResult);
//		}		
		return compareResult;
	}

	
	
}
