package io.transwarp.service.process.servlet;

import io.transwarp.common.util.ExecShell;

public class JInfoProcessCheckImpl implements ProcessCheck {

	private String command;
	private String ipAddress;
	
	public JInfoProcessCheckImpl(String command, String ipAddress) {
		this.command = command;
		this.ipAddress = ipAddress;
	}
	
	@Override
	public String getResult() {
		StringBuffer jinfoResult = new StringBuffer();
		String cmdResult = ExecShell.exec(ipAddress, command);
		String[] lines = cmdResult.split("\n");
		for (String line : lines) {
			if (line.startsWith("java.version")) {
				String[] items = line.split(" = ");
				jinfoResult.append(items[0]).append("|").append(items[1]).append("\n");
			} else if (line.startsWith("-agentpath")) {
				String[] items = line.split("\\s+");
				jinfoResult.append(items[0]).append("|");
				for (String item : items) {
					if (item.startsWith("-Xmx") || item.startsWith("-Xms") || 
						item.startsWith("-Xss") || item.startsWith("-Dngmr.task.pipeline")
						|| item.startsWith("-XX:CMSInitiatingOccupancyFraction")) {
						jinfoResult.append(item).append(" ");
					}
				}
				jinfoResult.append("\n");
			}
		}
		return jinfoResult.toString().trim();
	}
}
