package io.transwarp.service.process.servlet;

import io.transwarp.common.util.ExecShell;


public class JmapProcessCheckImpl implements ProcessCheck {
	
	private String command;
	private String ipAddress;
	
	public JmapProcessCheckImpl(String command, String ipAddress) {
		this.command = command;
		this.ipAddress = ipAddress;
	}
	
	@Override
	public String getResult() {
		StringBuffer jmapResult = new StringBuffer();
		String result = ExecShell.exec(ipAddress, command);
		String[] lines = result.split("\n");
		int number = lines.length;
		int minRow = Math.min(number, 23);
		for (int i = 0; i < minRow; i++) {
			jmapResult.append(lines[i].trim().replaceAll("\\s+", "|")).append("\n");
		}
		if (minRow > 1 && minRow < number) {
			jmapResult.append("……|……|……|……\n");
		}
		if (minRow != number) {
			jmapResult.append(lines[number - 1].trim().replaceAll("\\s+", "|"));
		}
		return jmapResult.toString();
	}

}
