package io.transwarp.service.process.servlet;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import io.transwarp.common.util.ExecShell;

public class JstackProcessCheckImpl implements ProcessCheck {
	
	private String command;
	private String ipAddress;
	
	public JstackProcessCheckImpl(String command, String ipAddress) {
		this.command = command;
		this.ipAddress = ipAddress;
	}
	
	@Override
	public String getResult() {
		String result = ExecShell.exec(ipAddress, command);
		String[] lines = result.split("\n");
		Map<String, Integer> threadNumber = new HashMap<String, Integer>();
		for (String line : lines) {
			Integer number = threadNumber.get(line);
			if (number == null) {
				number = 0;
			}
			number += 1;
			threadNumber.put(line, number);
		}
		return getResultString(threadNumber);
	}
	
	private String getResultString(Map<String, Integer> threadNumber) {
		StringBuffer title = new StringBuffer("java thread status");
		StringBuffer value = new StringBuffer("thread number");
		for (Iterator<Entry<String, Integer>> entrys = threadNumber.entrySet().iterator(); entrys.hasNext(); ) {
			Entry<String, Integer> entry = entrys.next();
			title.append("|").append(entry.getKey());
			value.append("|").append(entry.getValue());
		}
		return title.toString() + "\n" + value.toString();
	}

}
