package io.transwarp.service.process.servlet;

import io.transwarp.common.util.ExecShell;

public class JstatProcessCheckImpl implements ProcessCheck{

	private String command;
	private String ipAddress;
	
	public JstatProcessCheckImpl(String command, String ipAddress) {
		this.command = command;
		this.ipAddress = ipAddress;
	}
	
	@Override
	public String getResult() {
		String result = ExecShell.exec(ipAddress, command);
		StringBuffer jstatResult = new StringBuffer();
		String[] lines = result.split("\n");
		for (String line : lines) {
			jstatResult.append(line.trim().replaceAll("\\s+", "|")).append("\n");
		}
		return jstatResult.toString();
	}
}
