package io.transwarp.service.process.servlet;

import java.util.Locale;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.ReadXmlUtil;
import io.transwarp.common.bean.service.ProcessBean;
import io.transwarp.common.util.AbstractRunnable;
import io.transwarp.common.util.ExecShell;
import io.transwarp.inspection.CheckItemEnum;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessCheckRunnable extends AbstractRunnable {

	private final static String[] checkItem = new String[]{"jinfo", "jmap", "jstat", "jstack","gcCheck"}; 
	private final Logger log = LoggerFactory.getLogger(ProcessCheckRunnable.class);
	private final String servicename;
	private final String ipAddress;
	private final String roleType;
	//private final String configHead;
	private final ReadXmlUtil prop_process_check;
	
	private final ProcessBean process;
	
	public ProcessCheckRunnable(final ProcessBean process,
			final String ipAddress,
			final ReadXmlUtil prop_process_check) {
		this.process = process;
		this.prop_process_check = prop_process_check;
		this.servicename = process.getServicename();
		this.ipAddress = ipAddress;
		this.roleType = process.getRoleType();
	}

	@Override
	public void startCheck() throws Exception {
		log.info("begin check process of service [{}]", servicename);
		String dockerHead = getDockerHead();
		String processID = getProcessID(dockerHead);
		if (processID.equals("")) {
			throw new Exception("get process id error");
		}
		getProcessJvmInfo(dockerHead, processID);	
	}
	
	@Override
	public void dealWithError(Exception e) {
		String errorMessage = String.format("check process of service [%s] is faild | %s", servicename, e.getMessage());
		GlobalArgs.ERROR_INFO.add(errorMessage);
		log.error(errorMessage);
		e.printStackTrace();		
	}
	
	@Override
	public void closeThread() {
		log.info("process check of service [{}] is completed", servicename);
		GlobalArgs.timeStatisticses.get(CheckItemEnum.SERVICE.name()).setEndTime();
	}
	
	private String getDockerHead() throws Exception {
		if (GlobalArgs.version.startsWith("4")) {
			return "";
		}
		String command = String.format("sudo docker ps | grep %s | awk '{print $1}'", roleType.substring(0, 12));
		String result = ExecShell.exec(ipAddress, command).trim();
		String[] dockerIDs = result.split("\n");
		return String.format("sudo docker exec %s ", dockerIDs[0].trim());
	}
	
	private String getProcessID(final String dockerHead) throws Exception {
		String command = dockerHead + prop_process_check.getProperty(String.format("process.%s.id", roleType.toLowerCase(Locale.getDefault())), "");
		String result = ExecShell.exec(ipAddress, command).trim();
		if (result.equals("")) {
			log.info("get Process ID faild, exec command is [{}], service role is [{}]", command, servicename + ":" + roleType);
		}
		return result;
	}
	
	private void getProcessJvmInfo(final String dockerHead, final String processID) {
		
		for (String item : checkItem) {
			String command = dockerHead;
			if (processID.equals("")) {
				continue;
			}
			command += prop_process_check.getProperty(String.format("process.%s.command", item), "").replaceAll("\\(id\\)", processID);
			ProcessCheck check = null;
			if (item.equals("jinfo")) {
				check = new JInfoProcessCheckImpl(command, ipAddress);
			} else if (item.equals("jmap")) {
				check = new JmapProcessCheckImpl(command, ipAddress);
			} else if (item.equals("jstat")) {
				//check = new JstatProcessCheckImpl(command, ipAddress);
			} else if (item.equals("jstack")) {
				check = new JstackProcessCheckImpl(command, ipAddress);
			} else if (item.equals("gcCheck")) {
				GcCheckProcessCheck gcpc = new GcCheckProcessCheck(prop_process_check,dockerHead,processID,ipAddress);
				try {
					String jinfoCMSResult = gcpc.getJinfoCMSResult();
					String jstatStringResults = gcpc.getJstatStringResults();
					//String compareResult = gcpc.getCompareResult();
					//process.addJvmInfo("jinfoCMS", jinfoCMSResult);
					process.addJvmInfo("jstat", jinfoCMSResult+"\n"+jstatStringResults);
					//展示比较结果
					//process.addJvmInfo("gcCheck", compareResult);
				} catch (Exception e) {
					e.printStackTrace();
				}
			} else {
				throw new RuntimeException("no completed this check item : " + item);
			}
			try {
				if(null != check){
					String result = check.getResult();
					process.addJvmInfo(item, result);
				}				
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
}
