package io.transwarp.table.comparison;

import io.transwarp.common.bean.table.HolodeskTableBean;
import io.transwarp.report.comparison.Comparison;

import java.util.Comparator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;

public class HolodeskComparisonImpl implements Comparison {

	private final ComparisonResultOfTable comparisonResult;
	private final Map<String, HolodeskTableBean> tables;
	private final Set<String> holodeskHosts;
	private final String servicename;
	
	public HolodeskComparisonImpl(final ComparisonResultOfTable comparisonResult,
			final String servicename,
			final Map<String, HolodeskTableBean> tables) {
		this.comparisonResult = comparisonResult; 
		this.tables = tables;
		this.servicename = servicename;
		this.holodeskHosts = new TreeSet<String>();
	}
	
	@Override
	public void comparison() {
		int number = tables.size();
		HolodeskTableBean[] orderTables = new HolodeskTableBean[number];
		int index = 0;
		for (Entry<String, HolodeskTableBean> entry : tables.entrySet()) {
			HolodeskTableBean table = entry.getValue();
			Map<String, Long> blockSize = table.getBlockSizes();
			for (Entry<String, Long> blockEntry : blockSize.entrySet()) {
				this.holodeskHosts.add(blockEntry.getKey());
			}
			orderTables[index++] = table;
		}
		Arrays.sort(orderTables, new Comparator<HolodeskTableBean>() {
			@Override
			public int compare(HolodeskTableBean table1, HolodeskTableBean table2) {
				Long total1 = table1.getTotalSize();
				Long total2 = table2.getTotalSize();
				if(total1 > total2) {
					return -1;
				} else if (total1 == total2) {
					return 0;
				} else {
					return 1;
				}
			}
		});
		comparisonResult.holodeskTables.put(servicename, orderTables);
		comparisonResult.holodeskHosts.put(servicename, holodeskHosts);
	}
}
