package io.transwarp.table.comparison;

import java.util.Map;
import java.util.Map.Entry;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.TableInfo;
import io.transwarp.common.bean.table.EsTableBean;
import io.transwarp.common.bean.table.HBaseTableBean;
import io.transwarp.common.bean.table.HolodeskTableBean;
import io.transwarp.common.bean.table.OrcTableBean;
import io.transwarp.common.bean.table.TextTableBean;
import io.transwarp.report.comparison.Comparison;

public class TableComparisonImpl implements Comparison {
	
	private final ComparisonResultOfTable comparisonResult;
	private final TableInfo tableInfo;
	
	public TableComparisonImpl(final ComparisonResultOfTable comparisonResult,
			final TableInfo tableInfo) {
		this.comparisonResult = comparisonResult;
		this.tableInfo = tableInfo;
	}

	@Override
	public void comparison() throws Exception {
		if (GlobalArgs.checkSelect.isTextCheck()) {
			comparisonText(tableInfo.TABLE_TEXT.getAllTextTables());
		}
		if (GlobalArgs.checkSelect.isOrcCheck()) {
			comparisonOrc();
		}
		if (GlobalArgs.checkSelect.isHbaseCheck()) {
			comparisonHBase();
		}
		if (GlobalArgs.checkSelect.isHolodeskCheck()) {
			comparisonHolodesk();
		}
		if (GlobalArgs.checkSelect.isEsCheck()) {
			comparisonES();
		}
	}
	
	private void comparisonText(Map<String, Map<String, TextTableBean>> allTables) {
		try {
			for (Entry<String, Map<String, TextTableBean>> entry : allTables.entrySet()) {
				Comparison comparison = new TextComparisonImpl(comparisonResult, entry.getKey(), entry.getValue());
				comparison.comparison();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void comparisonOrc() {
		try {
			Map<String, Map<String, OrcTableBean>> allOrcTables = tableInfo.TABLE_ORC.getAllOrcTables();
			for (Entry<String, Map<String, OrcTableBean>> entry : allOrcTables.entrySet()) {
				Comparison comparison = new OrcComparisonImpl(comparisonResult, entry.getKey(), entry.getValue());
				comparison.comparison();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void comparisonHBase() {
		try {
			Map<String, Map<String, HBaseTableBean>> allHBaseTables = tableInfo.TABLE_HBASE.getAllHBaseTables();
			for (Entry<String, Map<String, HBaseTableBean>> entry : allHBaseTables.entrySet()) {
				Comparison comparison = new HBaseComparisonImpl(comparisonResult, entry.getKey(), entry.getValue());
				comparison.comparison();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void comparisonHolodesk() {
		try {
			Map<String, Map<String, HolodeskTableBean>> allHolodeskTables = tableInfo.TABLE_HOLODESK.getAllHolodeskTables();
			for (Entry<String, Map<String, HolodeskTableBean>> entry : allHolodeskTables.entrySet()) {
				Comparison comparison = new HolodeskComparisonImpl(comparisonResult, entry.getKey(), entry.getValue());
				comparison.comparison();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void comparisonES() {
		try {
			Map<String, Map<String, EsTableBean>> allEsTables = tableInfo.TABLE_ES.getAllEsTables();
			for (Entry<String, Map<String, EsTableBean>> entry : allEsTables.entrySet()) {
				Comparison comparison = new ESTableComparisonImpl(comparisonResult, entry.getKey(), entry.getValue());
				comparison.comparison();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
