package io.transwarp.table.comparison;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.table.TextTableBean;
import io.transwarp.common.util.UtilTools;
import io.transwarp.report.comparison.Comparison;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

public class TextComparisonImpl implements Comparison {

	private final Map<String, TextTableBean> tables;
	private final ComparisonResultOfTable comparisonResult;
	private final String servicename;
	private long smallFileSizeLimit;
	private int numberLimit;
	
	public TextComparisonImpl(final ComparisonResultOfTable comparisonResult,
			final String servicename,
			final Map<String, TextTableBean> tables) {
		this.comparisonResult = comparisonResult;
		this.tables = tables;
		this.servicename = servicename;
		this.smallFileSizeLimit = Long.valueOf(GlobalArgs.prop_rules.getProperty("cluster.smallFile.size.limit", "1"))*1024*1024;
		this.numberLimit = Integer.valueOf(GlobalArgs.prop_rules.getProperty("table.text.smallFile.number.limit", "100"));
	}
	
	@Override
	public void comparison() throws Exception {
		int tableNumber = tables.size();
		TextTableBean[] orderTables = new TextTableBean[tableNumber];
		int index = 0;
		for (Entry<String, TextTableBean> entry : tables.entrySet()) {
			TextTableBean table = entry.getValue();
			orderTables[index++] = check(table);
		}
		Arrays.sort(orderTables, new Comparator<TextTableBean>() {
			@Override
			public int compare(TextTableBean table1, TextTableBean table2) {
				int smallFileNumber1 = table1.getSmallFileNumber();
				int smallFileNumber2 = table2.getSmallFileNumber();
				if (smallFileNumber1 > smallFileNumber2) {
					return -1;
				} else if (smallFileNumber1 == smallFileNumber2) {
					return 0;
				} else {
					return 1;
				}
			}
		});
		comparisonResult.textTables.put(servicename, orderTables);
	}
	
	private TextTableBean check(final TextTableBean table) {
		List<Long> dataFiles = table.getDataFileSizes();
		int totalNumber = dataFiles.size();
		if (totalNumber == 0) {
			return table;
		}
		int smallFileNumber = 0;
		Long[] orderFiles = new Long[totalNumber];
		for (int i = 0; i < totalNumber; i++) {
			orderFiles[i] = dataFiles.get(i);
			if (orderFiles[i] < smallFileSizeLimit) {
				smallFileNumber += 1;
			}
		}
		Arrays.sort(orderFiles);
		String result = String.format("%s|%s|%s|%s", UtilTools.getCarrySize(orderFiles[totalNumber - 1]), 
				UtilTools.getCarrySize(orderFiles[totalNumber/2]), UtilTools.getCarrySize(orderFiles[0]), totalNumber);
		table.setFileComparison(result);
		table.setSmallFileNumber(smallFileNumber);
		table.setSmallFilePercent(String.format("%.2f %%", smallFileNumber*100.0/totalNumber));
		if (smallFileNumber > numberLimit) {
			comparisonResult.textErrorInfos.add(new String[]{String.format("%s.%s.%s", servicename, table.getDatabase(), table.getTablename()),
					"small file number too many",
					String.format("small file number is %s", smallFileNumber)});
		}
		return table;
	}
}
