package io.transwarp.table.es.report;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import jxl.write.Label;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import io.transwarp.common.bean.TableInfo;
import io.transwarp.report.xls.ReportEnum;
import io.transwarp.report.xls.XlsReport;

public class ESParamXlsReportImpl implements XlsReport {

	private final WritableSheet sheet;
	private final TableInfo tableInfo;
	private int maxCol;
	
	public ESParamXlsReportImpl(final WritableWorkbook workbook,
			final ReportEnum checkItem,
			final TableInfo tableInfo) {
		this.tableInfo = tableInfo;
		this.sheet = workbook.createSheet("serviceCheck_es", checkItem.ordinal());
		this.maxCol = 0;
	}
	
	@Override
	public void writeSheet() throws Exception {
		Map<String, String> searchNodeState = tableInfo.TABLE_ES.getSearchNodeState();
		Map<String, String> searchSetting = tableInfo.TABLE_ES.getSearchSetting();
		Map<String, String> searchThreadPool = tableInfo.TABLE_ES.getSearchThreadPool();
		Map<String, List<String[]>> searchIndices = tableInfo.TABLE_ES.getSearchIndices();
		int beginRow = 0;
		int beginCol = 0;
		for (Entry<String, String> entry : searchNodeState.entrySet()) {
			String servicename = entry.getKey();
			String nodeState = entry.getValue();
			String setting = searchSetting.get(servicename);
			String threadPool = searchThreadPool.get(servicename);
			List<String[]> indices = searchIndices.get(servicename);
			sheet.addCell(new Label(beginCol++, beginRow++, servicename, CELL_BOLD));
			beginRow = writeNodeStats(beginCol, beginRow, nodeState);
			beginRow = writeSetting(beginRow, setting);
			beginRow = writeThreadPool(beginRow, threadPool);
			beginRow = writeIndices(beginRow, indices);
		}
		for (int i = 2; i < maxCol; i++) {
			sheet.setColumnView(i, 20);
		}
	}
	
	private int writeNodeStats(int beginCol, int beginRow, String nodeState) throws Exception {
		JSONArray json = JSONArray.fromObject(nodeState);
		if (json.size() == 0) {
			return beginRow;
		}
		sheet.addCell(new Label(beginCol++, beginRow++, "node stats", CELL_BOLD));
		int row = beginRow;
		List<String> titles = new ArrayList<String>();
		JSONObject temp = json.getJSONObject(0);
		for (Iterator<?> entrys = temp.entrySet().iterator(); entrys.hasNext(); ) {
			Object entry = entrys.next();
			String[] items = entry.toString().split("=");
			titles.add(items[0]);
			sheet.addCell(new Label(beginCol, row++, items[0], CELL_BOLD));
		}
		for (int i = 0; i < json.size(); i++) {
			JSONObject node = json.getJSONObject(i);
			beginCol += 1;
			row = beginRow;
			for (String title : titles) {
				sheet.addCell(new Label(beginCol, row++, node.getString(title), CELL_THIN));
			}
		}
		this.maxCol = Math.max(maxCol, beginCol);
		return row + 1;
	}
	
	private int writeSetting(int beginRow, String setting) throws Exception {
		JSONObject json = JSONObject.fromObject(setting);
		if (json.size() == 0) {
			return beginRow;
		}
		sheet.addCell(new Label(1, beginRow++, "cluster setting", CELL_BOLD));
		for (Iterator<?> entrys = json.entrySet().iterator(); entrys.hasNext(); ) {
			Object entry = entrys.next();
			String[] items = entry.toString().split("=");
			sheet.addCell(new Label(2, beginRow, items[0], CELL_THIN));
			sheet.addCell(new Label(3, beginRow, items[1], CELL_THIN));
			beginRow += 1;
		}
		return beginRow + 1;
	}
	
	private int writeThreadPool(int beginRow, String threadPool) throws Exception {
		String[] lines = threadPool.split("\n");
		if (lines.length < 2) {
			return beginRow;
		}
		sheet.addCell(new Label(1, beginRow++, "thread pool", CELL_BOLD));
		for (String line : lines) {
			int column = 2;
			String[] items = line.split("\\s+");
			for (String item : items) {
				sheet.addCell(new Label(column++, beginRow, item, CELL_THIN));
			}
			beginRow += 1;
			this.maxCol = Math.max(maxCol, column);
		}
		return beginRow + 1;
	}
	
	private int writeIndices(int beginRow, List<String[]> indices) throws Exception {
		if (indices.size() < 2) {
			return beginRow;
		}
		sheet.addCell(new Label(1, beginRow++, "indices", CELL_BOLD));
		for (String[] line : indices) {
			if (line[0].equals("red")) {
				writeIndicesLine(beginRow++, 2, line, CELL_ERROR);
			} else {
				writeIndicesLine(beginRow++, 2, line, CELL_THIN);
			}
		}
		return beginRow + 1;
	}
	
	private void writeIndicesLine(int beginRow, int column, String[] line, WritableCellFormat cell) throws Exception {
		for (String item : line) {
			sheet.addCell(new Label(column++, beginRow, item, cell));
		}
	}
}
