package io.transwarp.table.es.report;

import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import net.sf.json.JSONObject;
import jxl.write.Label;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import io.transwarp.common.bean.TableInfo;
import io.transwarp.common.bean.table.EsTableBean;
import io.transwarp.report.xls.ReportEnum;
import io.transwarp.report.xls.XlsReport;
import io.transwarp.table.comparison.ComparisonResultOfTable;

public class ESTableXlsReportImpl implements XlsReport {
	
	private final WritableSheet sheet;
	private final TableInfo tableInfo;
	private final ComparisonResultOfTable comparisonResult;
	private final boolean encrypt;
	private int tableId;
	private int maxCol;
	
	public ESTableXlsReportImpl(final WritableWorkbook workbook,
			final ReportEnum checkItem,
			final TableInfo tableInfo,
			final ComparisonResultOfTable comparisonResult) {
		this.comparisonResult = comparisonResult;
		this.sheet = workbook.createSheet("ddl_es", checkItem.ordinal());
		this.tableInfo = tableInfo;
		this.encrypt = tableInfo.isEncryptTablename();
		this.tableId = 1;
		this.maxCol = 0;
	}

	@Override
	public void writeSheet() throws Exception {
		int beginRow = 0;
		int totalTable = 0;
		for (Entry<String, Map<String, EsTableBean>> entry : tableInfo.TABLE_ES.getAllEsTables().entrySet()) {
			String servicename = entry.getKey();
			Map<String, EsTableBean> esTables = entry.getValue();
			if (esTables.size() == 0) {
				continue;
			}
			totalTable += esTables.size();
			sheet.addCell(new Label(0, beginRow, servicename, CELL_BOLD));
			sheet.addCell(new Label(1, beginRow, "number of es table : " + esTables.size(), CELL_THIN));
			beginRow += 1;
			beginRow = writeEsTableInService(beginRow, servicename);
			beginRow += 1;
		}
		if (totalTable == 0) {
			sheet.addCell(new Label(1, 0, "no find es table", CELL_THIN));
		}
		for (int i = 0; i < maxCol; i++) {
            sheet.setColumnView(i, 20);
		}
		
	}
	
	private int writeEsTableInService(int beginRow, final String servicename) throws Exception {
		Map<String, Long> searchService = comparisonResult.searchServices.get(servicename);
		EsTableBean[] trueTables = comparisonResult.esTrueTables.get(servicename);
		EsTableBean[] errorTables = comparisonResult.esErrorTables.get(servicename);
		int column = 1;
		beginRow = writeTitle(column, beginRow, searchService);
		for (EsTableBean table : errorTables) {
			beginRow = writeTableInfo(beginRow++, table, searchService, CELL_ERROR);
		}
		for (EsTableBean table : trueTables) {
			beginRow = writeTableInfo(beginRow++, table, searchService, CELL_THIN);
		}
		return beginRow;
	}
	
	private int writeTitle(int beginCol, final int beginRow, final Map<String, Long> searchServices) throws Exception {
		sheet.mergeCells(beginCol, beginRow, beginCol, beginRow + 2);
		sheet.addCell(new Label(beginCol++, beginRow, "warning", CELL_BOLD));
		if (encrypt) {
			sheet.mergeCells(beginCol, beginRow, beginCol, beginRow + 2);
			sheet.addCell(new Label(beginCol++, beginRow, "table id", CELL_BOLD));
		} else {
			sheet.mergeCells(beginCol, beginRow, beginCol, beginRow + 2);
			sheet.addCell(new Label(beginCol++, beginRow, "database name", CELL_BOLD));
			sheet.mergeCells(beginCol, beginRow, beginCol, beginRow + 2);
			sheet.addCell(new Label(beginCol++, beginRow, "table name", CELL_BOLD));
			sheet.mergeCells(beginCol, beginRow, beginCol, beginRow + 2);
			sheet.addCell(new Label(beginCol++, beginRow, "es table name", CELL_BOLD));
		}
		
		sheet.mergeCells(beginCol, beginRow, beginCol, beginRow + 2);
		sheet.addCell(new Label(beginCol++, beginRow, "shard type", CELL_BOLD));
		int column = beginCol;
		for (Entry<String, Long> entry : searchServices.entrySet()) {
			sheet.mergeCells(beginCol, beginRow + 1, beginCol + 3, beginRow + 1);
			sheet.addCell(new Label(beginCol, beginRow + 1, entry.getKey(), CELL_BOLD));
			sheet.addCell(new Label(beginCol++, beginRow + 2, "max size", CELL_BOLD));
			sheet.addCell(new Label(beginCol++, beginRow + 2, "median size", CELL_BOLD));
			sheet.addCell(new Label(beginCol++, beginRow + 2, "min size", CELL_BOLD));
			sheet.addCell(new Label(beginCol++, beginRow + 2, "shard number", CELL_BOLD));
		}
		if (beginCol - 1 > column) {
			sheet.mergeCells(column, beginRow, beginCol - 1, beginRow);
		}
		sheet.addCell(new Label(column, beginRow, "shard size", CELL_BOLD));
		sheet.mergeCells(beginCol, beginRow, beginCol, beginRow + 2);
		sheet.addCell(new Label(beginCol++, beginRow, "total shard size", CELL_BOLD));
		sheet.mergeCells(beginCol, beginRow, beginCol, beginRow + 2);
		sheet.addCell(new Label(beginCol++, beginRow, "total shard number", CELL_BOLD));
		this.maxCol = Math.max(maxCol, beginCol);
		return beginRow + 3;
	}
	
	private int writeTableInfo(int beginRow, final EsTableBean table, final Map<String, Long> searchServices, final WritableCellFormat cell) throws Exception {
		List<JSONObject> replicaShardList = table.getReplicaShardComparison();
		int number = replicaShardList.size() + 1;
		int endRow = beginRow + number - 1;
		int column = 1;
		sheet.mergeCells(column, beginRow, column, endRow);
		sheet.addCell(new Label(column++, beginRow, table.getWarning(), cell));
		if (encrypt) {
			sheet.mergeCells(column, beginRow, column, endRow);
			tableInfo.TABLE_ES.addEncryptES(tableId, String.format("%s.%s.%s", table.getDatabase(), table.getTablename(), table.getEsTablename()));
			sheet.addCell(new Label(column++, beginRow, String.valueOf(tableId++), cell));
		} else {
			sheet.mergeCells(column, beginRow, column, endRow);
			sheet.addCell(new Label(column++, beginRow, table.getDatabase(), cell));
			sheet.mergeCells(column, beginRow, column, endRow);
			sheet.addCell(new Label(column++, beginRow, table.getTablename(), cell));
			sheet.mergeCells(column, beginRow, column, endRow);
			sheet.addCell(new Label(column++, beginRow, table.getEsTablename(), cell));
		}
		writeShardInfo(column, beginRow, table.getPrimaryShardComparison(), searchServices, "primary", cell);
		for (int i = 1; i < number; i++) {
			writeShardInfo(column, beginRow + i, replicaShardList.get(i - 1), searchServices, "replica", cell);
		}
		return endRow + 1;
	}
	
	private void writeShardInfo(int column, 
			final int beginRow, 
			final JSONObject shardComparison, 
			final Map<String, Long> serviceHosts, 
			final String type, 
			final WritableCellFormat cell) throws Exception {
		sheet.addCell(new Label(column++, beginRow, type, cell));
		for (Entry<String, Long> entry : serviceHosts.entrySet()) {
			Object comparison = shardComparison.get(entry.getKey());
			String result = " | | |0";
			if (comparison != null) {
				result = comparison.toString();
			}
			String[] items = result.split("\\|");
			for (String item : items) {
				sheet.addCell(new Label(column++, beginRow, item, cell));
			}
		}
		sheet.addCell(new Label(column++, beginRow, shardComparison.getString("totalSize"), cell));
		sheet.addCell(new Label(column++, beginRow, shardComparison.getString("totalNumber"), cell));
	}
}
