package io.transwarp.table.es.servlet;

import io.transwarp.common.util.ExecShell;

import org.apache.log4j.Logger;

public class CheckSearchHealth {

	private static final Logger LOG = Logger.getLogger(CheckSearchHealth.class);
	private String ipAddress;
	private String command;
	private Long waitTime;
	private int loopCount;
	
	public CheckSearchHealth(String ipAddress, String command, String[] waitTime) {
		this.ipAddress = ipAddress;
		this.command = command;
		this.waitTime = Long.valueOf(waitTime[0]);
		this.loopCount = Integer.valueOf(waitTime[1]);
	}
	
	public String check() throws Exception {
		String statusValue = "";
		String initValue = "";
		while (loopCount > 0) {
			String result = ExecShell.exec(ipAddress, command);
			String[] lines = result.split("\n");
			if (lines.length < 2) {
				LOG.error(String.format("check serch service health faild, command is \"%s\", result is %s", command, result));
				return "";
			}
			String[] firstLineItems = lines[0].split("\\s+");
			String[] secondLineItems = lines[1].split("\\s+");
			for (int i = 0; i < firstLineItems.length; i++) {
				if (firstLineItems[i].equals("status")) { 
					statusValue = secondLineItems[i];
				} else if (firstLineItems[i].equals("init")) {
					initValue = secondLineItems[i];
				}
			}
			if (!statusValue.equals("red") || initValue.equals("0")) {
				break;
			}else {
				LOG.info(String.format("search service is %s, wait %s millisecond", statusValue, waitTime));
				Thread.sleep(waitTime);
			}
			loopCount -= 1;
		}
		return statusValue;
	}
	
}
