package io.transwarp.table.es.servlet;

import io.transwarp.common.util.ExecShell;

import java.util.ArrayList;
import java.util.List;

public class CheckSearchIndices {

	private String ipAddress;
	private String command;
	private String orderItem;
	private String[][] values;
	
	public CheckSearchIndices(String ipAddress, String command, String sortKey) {
		this.ipAddress = ipAddress;
		this.command = command;
		this.orderItem = sortKey;
	}
	
	public List<String[]> check() throws Exception {
		List<String[]> outputItems = new ArrayList<String[]>();
		String result = ExecShell.exec(ipAddress, command);
		String[] lines = result.split("\n");
		if (lines.length < 2) {
			return outputItems;
		}
		String[] titleItems = lines[0].split("\\s+");
		int orderID = 5;
		for (int i = 0; i < titleItems.length; i++) {
			if (titleItems[i].equals(orderItem)) {
				orderID = i;
				break;
			}
		}
		values = new String[lines.length - 1][];
		for (int i = 1; i < lines.length; i++) {
			values[i - 1] = lines[i].split("\\s+");
		}
		sort(orderID, 0, values.length - 1);
		outputItems.add(titleItems);
		for (String[] value : values) {
			outputItems.add(value);
		}
		return outputItems;
	}
	
	private void sort(int id, int left, int right) {
		if (left >= right) {
			return;
		}
		int mid = (left + right) / 2;
		sort(id, left, mid);
		sort(id, mid + 1, right);
		mergeResult(id, left, mid, right);
	}
	
	private void mergeResult(int id, int left, int mid, int right) {
		String[][] temp = new String[right - left + 1][];
		int leftID = left;
		int rightID = mid + 1;
		int tempID = 0;
		while (leftID <= mid && rightID <= right) {
			int compareResult = compareIndicesInfo(values[leftID], values[rightID], id);
			if (compareResult > 0) {
				temp[tempID++] = values[leftID++];
			} else {
				temp[tempID++] = values[rightID++];
			}
		}
		while (leftID <= mid) {
			temp[tempID++] = values[leftID++];
		}
		while (rightID <= right) {
			temp[tempID++] = values[rightID++];
		}
		for (int i = left; i <= right; i++) {
			values[i] = temp[i - left];
		}
	}
	
	private int compareIndicesInfo(String[] line1, String[] line2, int id) {
		int status1 = changeHealthToInt(line1[0]);
		int status2 = changeHealthToInt(line2[0]);
		if (status1 > status2) {
			return 1;
		} else if (status1 < status2) {
			return -1;
		} else {
			Long num1 = Long.valueOf(line1[id]);
			Long num2 = Long.valueOf(line2[id]);
			if (num1 > num2) {
				return 1;
			} else {
				return -1;
			}
		}
	}
	
	private int changeHealthToInt(String status) {
		if (status.equals("red")) {
			return 3;
		} else if (status.equals("yellow")) {
			return 2;
		} else if (status.equals("green")) {
			return 1;
		} else {
			return 0;
		}
	}
}
