package io.transwarp.table.es.servlet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.transwarp.common.util.ExecShell;


public class CheckSearchMaster {

	private static final Logger log = LoggerFactory.getLogger(CheckSearchMaster.class);
	private String ipAddress;
	private String command;
	
	public CheckSearchMaster(String ipAddress, String command) {
		this.ipAddress = ipAddress;
		this.command = command;
	}
	
	public String check() throws Exception {
		String result = ExecShell.exec(ipAddress, command);
		String[] lines = result.split("\n");
		int hostValueID = 0;
		int masterValueID = 0;
		String[] titleItems = lines[0].split("\\s+");
		for (int i = 0; i < titleItems.length; i++) {
			if (titleItems[i].equals("host")) {
				hostValueID = i;
			} else if (titleItems[i].equals("master")) {
				masterValueID = i;
			}
		}
		for (int i = 1; i < lines.length; i++) {
			String[] items = lines[i].split("\\s+");
			int id = 0;
			if (masterValueID >= items.length) {
				id = items.length - (titleItems.length - masterValueID);
			} else {
				id = masterValueID;
			}
			if (items[id].equals("m") || items[id].equals("*")) {
				return items[hostValueID];
			}
		}
		log.warn(String.format("get search server master faild, command is \"%s\", result is :\n%s", command, result));
		return ipAddress;
	}
}
