package io.transwarp.table.es.servlet;

import io.transwarp.common.util.ExecShell;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;

public class CheckSearchNodeState {
	
	private String ipAddress;
	private String command;
	private Map<String, String> buffer;
	private String[] itemKeys;
	
	public CheckSearchNodeState(String ipAddress, String command, String[] keys) {
		this.ipAddress = ipAddress;
		this.command = command;
		this.itemKeys = keys;
		this.buffer = new HashMap<String, String>();
	}

	public String check() throws Exception {
		JSONArray answerArray = new JSONArray();
		String result = ExecShell.exec(ipAddress, command);
		JSONObject json = JSONObject.fromObject(result);
		JSONObject nodes = json.getJSONObject("nodes");
		for (Iterator<?> entrys = nodes.entrySet().iterator(); entrys.hasNext(); ) {
			Object entry = entrys.next();
			String[] items = entry.toString().split("=");
			buffer.clear();
			analysisNodeInfo("", JSONObject.fromObject(items[1]));
			JSONObject node = new JSONObject();
			for (String key : itemKeys) {
				String value = buffer.get(key);
				if (value == null || value.equals("")) {
					value = "0";
				}
				node.put(key, value);
			}
			answerArray.add(node);
		}
		return answerArray.toString();
	}
	
	private void analysisNodeInfo(String father, JSONObject json) throws Exception {
		for (Iterator<?> entrys = json.entrySet().iterator(); entrys.hasNext(); ) {
			Object entry = entrys.next();
			String[] items = entry.toString().split("=");
			try {
				JSONObject child = JSONObject.fromObject(items[1]);
				analysisNodeInfo(father + items[0] + ".", child);
			} catch (JSONException e) {
				buffer.put(father + items[0], items[1]);
			}
		}
	}
}
