package io.transwarp.table.es.servlet;

import io.transwarp.common.util.ExecShell;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import net.sf.json.JSONException;
import net.sf.json.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckSearchSetting {

	private static final Logger LOG = LoggerFactory.getLogger(CheckSearchSetting.class);
	private String ipAddress;
	private String command;
	private Map<String, String> buffer;
	
	public CheckSearchSetting(String ipAddress, String command) {
		this.ipAddress = ipAddress;
		this.command = command;
	}
	
	public String check() throws Exception {
		JSONObject answer = new JSONObject();
		String result = ExecShell.exec(ipAddress, command);
		try {
			JSONObject json = JSONObject.fromObject(result);
			buffer = new HashMap<String, String>();
			analysisJson("", json);
			for (Iterator<Entry<String, String>> entrys = buffer.entrySet().iterator(); entrys.hasNext();  ) {
				Entry<String, String> entry = entrys.next();
				answer.put(entry.getKey(), entry.getValue());
			}
		} catch (Exception e) {
			LOG.error(String.format("check search cluster setting faild, command is \"%s\", result is %s", command, ipAddress));
			e.printStackTrace();
		}
		return answer.toString();
	}
	
	private void analysisJson(String father, JSONObject json) throws Exception {
		for (Iterator<?> entrys = json.entrySet().iterator(); entrys.hasNext(); ) {
			Object entry = entrys.next();
			String[] items = entry.toString().split("=");
			try {
				JSONObject child = JSONObject.fromObject(items[1]);
				analysisJson(father + items[0] + ".", child);
			} catch (JSONException e) {
				buffer.put(father + items[0], items[1]);
			}
		}
	}
}