package io.transwarp.table.es.servlet;

import io.transwarp.common.bean.table.EsTableBean;
import io.transwarp.common.util.ExecShell;
import io.transwarp.common.util.UtilTools;

import java.util.Map;
import java.util.Map.Entry;

import net.sf.json.JSONObject;


public class CheckSearchShard {
	
	private Map<String, EsTableBean> tables;
	private String ipAddress;
	private String command;
	
	public CheckSearchShard(final Map<String, EsTableBean> tables,
			final String ipAddress,
			final String command) {
		this.tables = tables;
		this.ipAddress = ipAddress;
		this.command = command;
	}
	
	public void check() throws Exception {
		try {
			String result = ExecShell.exec(ipAddress, command);
			analysis(result);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void analysis(String shellResult) {
		EsTableBean table = null;
		String nowTable = "";
		String[] lines = shellResult.split("\n");
		for (String line : lines) {
			JSONObject json = new JSONObject();
			String[] items = line.split("\\s+");
			int len = items.length;
			if (len < 4) {
				continue;
			}
			String tablename = items[0];
			json.put("shardId", items[1]);
			json.put("prirep", items[2]);
			json.put("state", items[3]);
			json.put("host", items[len - 1]);
			if (len == 8) {
				json.put("size", UtilTools.getValueFromSize(items[5]));
			} else {
				json.put("size", "0");
			}
			table = getESTable(table, nowTable, tablename);
			nowTable = tablename;
			table.addShardInfo(json);
		}
	}
	
	private EsTableBean getESTable(EsTableBean table, String nowTable, String newTable) {
		if (table != null && nowTable.equals(newTable)) {
			return table;
		}
		for (Entry<String, EsTableBean> entry : tables.entrySet()) {
			EsTableBean temp = entry.getValue();
			if(temp.getEsTablename().equals(newTable)) {
				return temp;
			}
		}
		EsTableBean temp = new EsTableBean();
		temp.setEsTablename(newTable);
		temp.setDatabase("");
		temp.setTablename("");
		tables.put("InceptorTableNotExists:" + newTable, temp);
		return temp;
	}
	
	
}
