package io.transwarp.table.es.servlet;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.TableInfo;
import io.transwarp.common.bean.service.RoleBean;
import io.transwarp.common.bean.service.ServiceBean;
import io.transwarp.common.bean.table.EsTableBean;
import io.transwarp.common.util.ExecShell;
import io.transwarp.inspection.CheckItemEnum;
import io.transwarp.table.servlet.AbstractCheckOnDetail;

public class EsTableCheckOnDetail extends AbstractCheckOnDetail {
	
	private final ServiceBean search;
	private final Map<String, EsTableBean> tables;
	private final TableInfo tableInfo;

	private String masterIP;
	
	public EsTableCheckOnDetail(final ServiceBean service,
			final Map<String, EsTableBean> tables,
			final TableInfo tableInfo) {
		this.tableInfo = tableInfo;
		this.search = service;
		this.tables = tables;
	}
	
	@Override
	public void addTableCheck() throws Exception {
		if (search == null || search.getHealth().equals("DOWN")) {
			return;
		}
		getMasterIP();
		checkSearchHealth();
		if (GlobalArgs.checkSelect.isServiceCheckEs()) {
			checkSearchSetting();
			checkSearchStatus();
			checkSearchThreadPool();
			checkSearchIndices();
		}
		if (GlobalArgs.checkSelect.isEsCheck()) {
			checkSearchShard();
		}
		GlobalArgs.timeStatisticses.get(CheckItemEnum.TABLE.name()).setEndTime();
	}
	
	private void getMasterIP() {
		List<RoleBean> roles = search.getRoles();
		for (RoleBean role : roles) {
			if (role.getRoleType().matches("\\S*SEARCH\\S*")) {
				masterIP = role.getNode().getIpAddress();
				break;
			}
		}
		String command = tableInfo.prop_table_es.getProperty("masterNode.command", "curl -XGET (host):9200/_cat/nodes?v")
				.replaceAll("\\(host\\)", masterIP);
		try {
			CheckSearchMaster getMaster = new CheckSearchMaster(masterIP, command);
			masterIP = getMaster.check();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void checkSearchHealth() {
		String health;
		String command = tableInfo.prop_table_es.getProperty("clusterHealth.command", "curl -XGET (host):9200/_cat/health?v")
				.replaceAll("\\(host\\)", masterIP);
		String waitTime = tableInfo.prop_table_es.getProperty("clusterHealth.waitTime", "10000|60");
		try {
			CheckSearchHealth checkHealth = new CheckSearchHealth(masterIP, command, waitTime.split("\\|"));
			health = checkHealth.check();
		} catch (Exception e) {
			health = "";
			e.printStackTrace();
		}
		String serviceHealth = search.getHealth();
		search.setHealth(String.format("%s[%s]", serviceHealth, health));
	}
	
	private void checkSearchSetting() {
		String result;
		String command = tableInfo.prop_table_es.getProperty("clusterSetting.command", "curl -XGET (host):9200/_cluster/settings?pretty")
				.replaceAll("\\(host\\)", masterIP);
		try {
			CheckSearchSetting checkSetting = new CheckSearchSetting(masterIP, command);
			result = checkSetting.check();
		} catch (Exception e) {
			result = "";
			e.printStackTrace();
		}
		tableInfo.TABLE_ES.addSearchSetting(search.getName(), result);
	}
	
	private void checkSearchStatus() {
		String result;
		String command = tableInfo.prop_table_es.getProperty("nodeStats.command", "curl -XGET (host):9200/_nodes/stats?pretty")
				.replaceAll("\\(host\\)", masterIP);
		String keys = tableInfo.prop_table_es.getProperty("nodeStats.key", "");
		try {
			CheckSearchNodeState checkNodeState = new CheckSearchNodeState(masterIP, command, keys.split(";"));
			result = checkNodeState.check();
		} catch (Exception e) {
			result = "[]";
			e.printStackTrace();
		}
		tableInfo.TABLE_ES.addSearchNodeState(search.getName(), result);
	}
	
	private void checkSearchThreadPool() {
		String result;
		String command = tableInfo.prop_table_es.getProperty("threadPool.command", "curl -XGET (host):9200/_cat/thread_pool?v")
				.replaceAll("\\(host\\)", masterIP);
		try {
			result = ExecShell.exec(masterIP, command);
		} catch (Exception e) {
			result = "";
			e.printStackTrace();
		}
		tableInfo.TABLE_ES.addSearchThreadPool(search.getName(), result);
	}
	
	private void checkSearchIndices() {
		List<String[]> result;
		String command = tableInfo.prop_table_es.getProperty("indices.command", "curl -XGET (host):9200/_cat/indices?v")
				.replaceAll("\\(host\\)", masterIP);
		String sortKey = tableInfo.prop_table_es.getProperty("indices.sortKey", "doc.count");
		try {
			CheckSearchIndices checkIndices = new CheckSearchIndices(masterIP, command, sortKey);
			result = checkIndices.check();
		} catch (Exception e) {
			result = new ArrayList<String[]>();
			result.add(new String[]{"check indices faild", e.getMessage()});
			e.printStackTrace();
		}
		tableInfo.TABLE_ES.addSearchIndices(search.getName(), result);
	}
	
	private void checkSearchShard() {
		String command = tableInfo.prop_table_es.getProperty("shard.command", "")
				.replaceAll("\\(host\\)", masterIP);
		try {
			CheckSearchShard checkShard = new CheckSearchShard(tables, masterIP, command);
			checkShard.check();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
