package io.transwarp.table.holodesk.servlet;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.TableInfo;
import io.transwarp.common.bean.service.ConfigBean;
import io.transwarp.common.bean.service.RoleBean;
import io.transwarp.common.bean.service.ServiceBean;
import io.transwarp.common.bean.table.HolodeskTableBean;
import io.transwarp.common.util.MyThreadPool;
import io.transwarp.table.servlet.AbstractCheckOnDetail;

public class HolodeskTableCheckOnDetail extends AbstractCheckOnDetail {
	
	private static final String HOLODESK_PATH = "/holodesk";
	private final ServiceBean zookeeper;
	private final ServiceBean inceptor;
	private final Map<String, HolodeskTableBean> tables;
	private final TableInfo tableInfo;
	
	private ZkConnUtils zkConn;
	
	public HolodeskTableCheckOnDetail(final ServiceBean inceptor,
			final ServiceBean zookeeper,
			final Map<String, HolodeskTableBean> tables,
			final TableInfo tableInfo) {
		this.zookeeper = zookeeper;
		this.inceptor = inceptor;
		this.tables = tables;
		this.tableInfo = tableInfo;
	}

	@Override
	public void addTableCheck() throws Exception {
		List<RoleBean> roles = zookeeper.getRoles();
		zkConn = null;
		for (RoleBean role : roles) {
			String hostname = role.getNode().getHostName();
			try {
				zkConn = ZkConnUtils.getZKConnection(hostname);
				break;
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		
		getHolodeskTableFromZk();
		getParameterFromProp();
	}
	
	private void getHolodeskTableFromZk() {
		List<String> holodeskList = null;
		try {
			holodeskList = zkConn.getFileList(HOLODESK_PATH);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		if (holodeskList == null) {
			return;
		}
		
		for (String holodesk : holodeskList) {
			HolodeskTableBean table = tables.get(holodesk);
			if (table != null) {
				String[] items = holodesk.split("\\.");
				if (items.length == 1) {
					table.setDatabase("default");
					table.setTablename(holodesk);
				} else {
					table.setDatabase(items[0]);
					table.setTablename(items[1]);
				}
				tables.put(holodesk, table);
				MyThreadPool.addNewThread(new HolodeskTableCheckRunnable(zkConn, table));
			}
		}
	}

	private void getParameterFromProp() {
		Map<String, String> values = new HashMap<String, String>();
		ConfigBean config = inceptor.getConfig();
		Map<String, Map<String, String>> files = config.getConfigFiles("ngmr-env.sh");
		for (Entry<String, Map<String, String>> entry : files.entrySet()) {
			Map<String, String> fileValue = entry.getValue();
			String fastdisk_dir = "";
			String fastdisk_size = "";
			if (fileValue != null) {
				if (GlobalArgs.version.startsWith("4")) {
					fastdisk_dir = fileValue.get("NGMR_FASTDISK_DIR");
					fastdisk_size = fileValue.get("NGMR_FASTDISK_SIZE");
				} else {
					fastdisk_dir = fileValue.get("SPARK_FASTDISK_DIR");
					fastdisk_size = fileValue.get("NGMR_CACHE_SIZE");
				}
				values.put("ngmr.fastdisk.dir", fastdisk_dir);
				values.put("ngmr.fastdisk.size", fastdisk_size);
			} 
		}
		tableInfo.TABLE_HOLODESK.addHolodeskParameter(inceptor.getName(), values);
	}
	
}
