package io.transwarp.table.holodesk.servlet;

import java.util.List;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.table.HolodeskTableBean;
import io.transwarp.common.util.AbstractRunnable;
import io.transwarp.inspection.CheckItemEnum;

public class HolodeskTableCheckRunnable extends AbstractRunnable {

	private static final String HOLODESK_PATH = "/holodesk";
	
	private final ZkConnUtils zkConn;
	private final HolodeskTableBean table;
	
	public HolodeskTableCheckRunnable(final ZkConnUtils zkConn, 
			final HolodeskTableBean table) {
		this.zkConn = zkConn;
		this.table = table;
	}
	
	@Override
	public void startCheck() throws Exception {
		String blockName = String.format("%s/%s.%s/blocks", HOLODESK_PATH, table.getDatabase(), table.getTablename());
		Long version = zkConn.getVersion(blockName);
		String blockNameWithVersion = blockName + (version > 0 ? "/" + version : "");
		List<String> hostOfBlocks = zkConn.getFileList(blockNameWithVersion);
		for (String host : hostOfBlocks) {
			Long blockSize = zkConn.getFileSize(blockNameWithVersion + "/" + host);
			table.addBlock(host, blockSize);
		}
	}
	
	@Override
	public void dealWithError(Exception e) {
		GlobalArgs.ERROR_INFO.add(String.format("check holodesk table [%s.%s] is faild | %s", table.getDatabase(), table.getTablename(), e.getMessage()));
		e.printStackTrace();		
	}
	
	@Override
	public void closeThread() {
		GlobalArgs.timeStatisticses.get(CheckItemEnum.TABLE.name()).setEndTime();
	}
}
