package io.transwarp.table.report;

import java.util.Locale;
import java.util.Map;

import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import io.transwarp.report.xls.XlsReport;
import io.transwarp.table.servlet.TableTypeEnum;

public class EncryptTableXlsReportImpl implements XlsReport {
	
	private final WritableSheet sheet;
	private final String[] titles;
	private final Map<Integer, String> encryptInfos;
	
	public EncryptTableXlsReportImpl(final WritableWorkbook workbook,
			final TableTypeEnum tableType,
			final String[] titles,
			final Map<Integer, String> encryptInfos) {
		this.sheet = workbook.createSheet(tableType.name().toLowerCase(Locale.getDefault()), tableType.ordinal());
		this.titles = titles;
		this.encryptInfos = encryptInfos;
	}

	@Override
	public void writeSheet() throws Exception {
		int beginRow = 1;
		writeTitle(beginRow++);
		int number = encryptInfos.size();
		for (int i = 1; i <= number; i++) {
			String tablename = encryptInfos.get(i);
			String[] items = tablename.split("\\.");
			int column = 1;
			sheet.addCell(new Label(column++, beginRow, String.valueOf(i), CELL_THIN));
			for (String item : items) {
				sheet.addCell(new Label(column++, beginRow, item, CELL_THIN));
			}
			beginRow += 1;
		}
		int maxCol = titles.length;
		for (int i = 1; i <= maxCol; i++) {
			sheet.setColumnView(i, 20);
		}
	}
	
	private void writeTitle(final int beginRow) throws Exception {
		int column = 1;
		for (String title : titles) {
			sheet.addCell(new Label(column++, beginRow, title, CELL_BOLD));
		}
	}
}
