package io.transwarp.table.servlet;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.TableInfo;
import io.transwarp.common.bean.service.ServiceBean;
import io.transwarp.common.bean.table.*;
import io.transwarp.table.es.servlet.EsTableCheckOnDetail;
import io.transwarp.table.hbase.servlet.HBaseTableCheckOnDetail;
import io.transwarp.table.holodesk.servlet.HolodeskTableCheckOnDetail;
import io.transwarp.table.orc.servlet.OrcTableCheckOnDetail;
import io.transwarp.table.text.servlet.TextTableCheckOnDetail;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import net.sf.json.JSONObject;

public abstract class AbstractCheckOnDetail {
	
	public abstract void addTableCheck() throws Exception ;
	
	public static AbstractCheckOnDetail.Build custom() {
		return new Build();
	}
	
	public static class Build {
		private Map<String, OrcTableBean> orcTables;
		private Map<String, HBaseTableBean> hbaseTables;
		private Map<String, TextTableBean> textTables;
		private Map<String, HolodeskTableBean> holodeskTables;
		private Map<String, EsTableBean> esTables;
		private Map<String, TextTableBean> otherTables;

		private TableInfo tableInfo;
		
		private ServiceBean inceptor;
		private ServiceBean hdfs;
		private ServiceBean hyperbase;
		private ServiceBean search;
		private ServiceBean zookeeper;
		
		private JSONObject connectionInfo;
		
		Build() {
			this.orcTables = new ConcurrentHashMap<String, OrcTableBean>();
			this.hbaseTables = new ConcurrentHashMap<String, HBaseTableBean>();
			this.holodeskTables = new ConcurrentHashMap<String, HolodeskTableBean>();
			this.esTables = new ConcurrentHashMap<String, EsTableBean>();
			this.textTables = new ConcurrentHashMap<String, TextTableBean>();
			this.otherTables = new ConcurrentHashMap<String, TextTableBean>();
			this.inceptor = null;
			hyperbase = null;
			search = null;
			this.zookeeper = null;
		}
		
		public AbstractCheckOnDetail build(TableTypeEnum type) throws Exception {
			switch (type) {
			case TEXT : 
				if (GlobalArgs.checkSelect.isTextCheck()) {
					System.out.println(String.format("add table check on detail: [%s]", type.name()));
					return new TextTableCheckOnDetail(hdfs.getName(), textTables, otherTables);
				} else {
					return null;
				}
			case ORC : 
				if (GlobalArgs.checkSelect.isOrcCheck()) {
					System.out.println(String.format("add table check on detail: [%s]", type.name()));
					return new OrcTableCheckOnDetail(hdfs.getName(), orcTables, connectionInfo);
				} else {
					return null;
				}
			case HBASE : 
				if (GlobalArgs.checkSelect.isHbaseCheck()) {
					System.out.println(String.format("add table check on detail: [%s]", type.name()));
					return new HBaseTableCheckOnDetail(hdfs.getName(), hyperbase, hbaseTables, tableInfo);
				} else {
					return null;
				}
			case HOLODESK : 
				if (GlobalArgs.checkSelect.isHolodeskCheck()) {
					System.out.println(String.format("add table check on detail: [%s]", type.name()));
					return new HolodeskTableCheckOnDetail(inceptor, zookeeper, holodeskTables, tableInfo);
				} else {
					return null;
				}
			case ES : 
				if (GlobalArgs.checkSelect.isEsCheck() || GlobalArgs.checkSelect.isServiceCheckEs()) {
					System.out.println(String.format("add table check on detail: [%s]", type.name()));
					return new EsTableCheckOnDetail(search, esTables, tableInfo);
				} else {
					return null;
				}
			default : throw new Exception("no find this table type : " + type.name());
			}
		}
		
		public Build setInceptor(ServiceBean inceptor) {
			this.inceptor = inceptor;
			return this;
		}
		
		public Build setHdfs(ServiceBean hdfs) {
			this.hdfs = hdfs;
			return this;
		}
		
		public Build setHyperbase(ServiceBean hyperbase) {
			this.hyperbase = hyperbase;
			return this;
		}
		
		public Build setSearch(ServiceBean search) {
			this.search = search;
			return this;
		}
		
		public Build setZookeeper(ServiceBean zookeeper) {
			this.zookeeper = zookeeper;
			return this;
		}
		
		public Build setOrcTables(Map<String, OrcTableBean> tables) {
			this.orcTables = tables;
			return this;
		}
		
		public Build setHBaseTables(Map<String, HBaseTableBean> tables) {
			this.hbaseTables = tables;
			return this;
		}
		
		public Build setHolodeskTables(Map<String, HolodeskTableBean> tables) {
			this.holodeskTables = tables;
			return this;
		}
		
		public Build setTextTables(Map<String, TextTableBean> tables) {
			this.textTables = tables;
			return this;
		}
		
		public Build setOtherTables(Map<String, TextTableBean> tables) {
			this.otherTables = tables;
			return this;
		}
		
		public Build setEsTables(Map<String, EsTableBean> tables) {
			this.esTables = tables;
			return this;
		}
		
		public Build setConnectedInfo(JSONObject connectionInfo) {
			this.connectionInfo = connectionInfo;
			return this;
		}
		
		public Build setProperty(TableInfo tableInfo) {
			this.tableInfo = tableInfo;
			return this;
		}
	}
}
