package io.transwarp.table.text.report;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import io.transwarp.common.bean.TableInfo;
import io.transwarp.common.bean.table.TextTableBean;
import io.transwarp.common.util.UtilTools;
import io.transwarp.report.xls.ReportEnum;
import io.transwarp.report.xls.XlsReport;

public class OtherTableXlsReportImpl implements XlsReport {
	
	private final WritableSheet sheet;
	private final Map<String, Map<String, TextTableBean>> allTables;
	private final TableInfo tableInfo;
	private final boolean encrypt;
	private int tableId;
	private int maxCol;
	
	public OtherTableXlsReportImpl(final WritableWorkbook workbook,
			final ReportEnum checkItem,
			final TableInfo tableInfo) {
		this.sheet = workbook.createSheet("ddl_other", checkItem.ordinal());
		this.allTables = tableInfo.getAllOtherTables();
		this.tableInfo = tableInfo;
		this.encrypt = tableInfo.isEncryptTablename();
		this.tableId = 1;
		this.maxCol = 0;
	}

	@Override
	public void writeSheet() throws Exception {
		int beginRow = 0;
		int totalTables = 0;
		for (Entry<String, Map<String, TextTableBean>> entry : allTables.entrySet()) {
			String servicename = entry.getKey();
			Map<String, TextTableBean> otherTables = entry.getValue();
			if (otherTables.size() == 0) {
				continue;
			}
			totalTables += otherTables.size();
			sheet.addCell(new Label(0, beginRow, servicename, CELL_BOLD));
			sheet.addCell(new Label(1, beginRow, "number of other table : " + otherTables.size(), CELL_THIN));
			beginRow += 1;
			beginRow = writeTableInfoInService(beginRow, otherTables);
			beginRow += 1;
		}
		if (totalTables == 0) {
			sheet.addCell(new Label(0, 0, "no other tables"));
		}
		for (int i = 0; i < maxCol; i++) {
			sheet.setColumnView(i, 20);
		}
	}
	
	private int writeTableInfoInService(int beginRow, Map<String, TextTableBean> otherTables) throws Exception {
		writeTitle(beginRow);
		beginRow += 2;
		for (Entry<String, TextTableBean> entry : otherTables.entrySet()) {
			TextTableBean table = entry.getValue();
			int column = 1;
			if (encrypt) {
				tableInfo.addEncryptOther(tableId, String.format("%s.%s", table.getDatabase(), table.getTablename()));
				sheet.addCell(new Label(column++, beginRow, String.valueOf(tableId++), CELL_THIN));
			} else {
				sheet.addCell(new Label(column++, beginRow, table.getDatabase(), CELL_THIN));
				sheet.addCell(new Label(column++, beginRow, table.getTablename(), CELL_THIN));
			}
			sheet.addCell(new Label(column++, beginRow, table.getOwner(), CELL_THIN));
			sheet.addCell(new Label(column++, beginRow, table.getFormat(), CELL_THIN));
			List<Long> fileSizes = table.getDataFileSizes();
			int number = fileSizes.size();
			if (number == 0) {
				sheet.addCell(new Label(column++, beginRow, "", CELL_THIN));
				sheet.addCell(new Label(column++, beginRow, "", CELL_THIN));
				sheet.addCell(new Label(column++, beginRow, "", CELL_THIN));
				sheet.addCell(new Label(column++, beginRow, "0", CELL_THIN));
			} else {
				Long[] orderSizes = new Long[number];
				orderSizes = fileSizes.toArray(orderSizes);
				Arrays.sort(orderSizes);
				sheet.addCell(new Label(column++, beginRow, UtilTools.getCarrySize(orderSizes[number - 1]), CELL_THIN));
				sheet.addCell(new Label(column++, beginRow, UtilTools.getCarrySize(orderSizes[number/2]), CELL_THIN));
				sheet.addCell(new Label(column++, beginRow, UtilTools.getCarrySize(orderSizes[0]), CELL_THIN));
				sheet.addCell(new Label(column++, beginRow, String.valueOf(number), CELL_THIN));
			}
			beginRow += 1;
		}
		return beginRow;
	}
	
	private void writeTitle(final int beginRow) throws Exception {
		int column = 1;
		if (encrypt) {
			sheet.mergeCells(column, beginRow, column, beginRow + 1);
			sheet.addCell(new Label(column++, beginRow, "tableId", CELL_BOLD));
		} else {
			sheet.mergeCells(column, beginRow, column, beginRow + 1);
			sheet.addCell(new Label(column++, beginRow, "database name", CELL_BOLD));
			sheet.mergeCells(column, beginRow, column, beginRow + 1);
			sheet.addCell(new Label(column++, beginRow, "table name", CELL_BOLD));
		}
		sheet.mergeCells(column, beginRow, column, beginRow + 1);
		sheet.addCell(new Label(column++, beginRow, "owner name", CELL_BOLD));
		sheet.mergeCells(column, beginRow, column, beginRow + 1);
		sheet.addCell(new Label(column++, beginRow, "table format", CELL_BOLD));
		sheet.mergeCells(column, beginRow, column + 3, beginRow);
		sheet.addCell(new Label(column, beginRow, "file size", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow, "max size", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow, "median size", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow, "min size", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow, "file number", CELL_BOLD));
		this.maxCol = Math.max(maxCol, column);
		
	}

}
