package io.transwarp.table.text.report;

import java.util.Map;
import java.util.Map.Entry;

import jxl.write.Label;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import io.transwarp.common.bean.TableInfo;
import io.transwarp.common.bean.table.TextTableBean;
import io.transwarp.report.xls.ReportEnum;
import io.transwarp.report.xls.XlsReport;
import io.transwarp.table.comparison.ComparisonResultOfTable;

public class TextXlsReportImpl implements XlsReport {
	
	private final WritableSheet sheet;
	private final ComparisonResultOfTable comparisonResult;
	private final TableInfo tableInfo;
	private final boolean encrypt;
	private int tableId;
	private int maxCol;
	
	public TextXlsReportImpl(final WritableWorkbook workbook,
			final ReportEnum checkItem,
			final TableInfo tableInfo,
			final ComparisonResultOfTable comparisonResult) {
		this.sheet = workbook.createSheet("ddl_text", checkItem.ordinal());
		this.tableInfo = tableInfo;
		this.comparisonResult = comparisonResult;
		this.encrypt = tableInfo.isEncryptTablename();
		this.tableId = 1;
		this.maxCol = 0;
	}

	@Override
	public void writeSheet() throws Exception {
		int beginRow = 0;
		int totalTable = 0;
		for (Entry<String, Map<String, TextTableBean>> entry : tableInfo.TABLE_TEXT.getAllTextTables().entrySet()) {
			String servicename = entry.getKey();
			Map<String, TextTableBean> textTables = entry.getValue();
			if (textTables.size() == 0) {
				continue;
			}
			totalTable += textTables.size();
			sheet.addCell(new Label(0, beginRow, servicename, CELL_BOLD));
			sheet.addCell(new Label(1, beginRow, "number of text table : " + textTables.size(), CELL_THIN));
			beginRow += 1;
			beginRow = writeTextTableInService(beginRow, servicename);
			beginRow += 1;
		}
		if (totalTable == 0) {
			sheet.addCell(new Label(1, 0, "no find text table", CELL_THIN));
		}
		for (int i = 0; i < maxCol; i++) {
			sheet.setColumnView(i, 20);
		}
	}
	
	private int writeTextTableInService(int beginRow, final String servicename) throws Exception {
		beginRow = writeTitle(beginRow);
		TextTableBean[] orderTables = comparisonResult.textTables.get(servicename);
		for (TextTableBean order : orderTables) {
			writeTableInfo(beginRow, order);
			beginRow += 1;
		}
		return beginRow;
	}
	
	private int writeTitle(final int beginRow) throws Exception {
		int column = 1;
		if (encrypt) {
			sheet.mergeCells(column, beginRow, column, beginRow + 1);
			sheet.addCell(new Label(column++, beginRow, "tableId", CELL_BOLD));
		} else {
			sheet.mergeCells(column, beginRow, column, beginRow + 1);
			sheet.addCell(new Label(column++, beginRow, "database name", CELL_BOLD));
			sheet.mergeCells(column, beginRow, column, beginRow + 1);
			sheet.addCell(new Label(column++, beginRow, "table name", CELL_BOLD));
		}
		sheet.mergeCells(column, beginRow, column, beginRow + 1);
		sheet.addCell(new Label(column++, beginRow, "owner name", CELL_BOLD));
		sheet.mergeCells(column, beginRow, column, beginRow + 1);
		sheet.addCell(new Label(column++, beginRow, "small file number", CELL_BOLD));
		sheet.mergeCells(column, beginRow, column, beginRow + 1);
		sheet.addCell(new Label(column++, beginRow, "small file proportion", CELL_BOLD));
		sheet.mergeCells(column, beginRow, column + 3, beginRow);
		sheet.addCell(new Label(column, beginRow, "file size", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow + 1, "max size", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow + 1, "median size", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow + 1, "min size", CELL_BOLD));
		sheet.addCell(new Label(column++, beginRow + 1, "file number", CELL_BOLD));
		this.maxCol = Math.max(maxCol, column);
		return beginRow + 2;
	}
	
	private void writeTableInfo(final int beginRow, final TextTableBean table) throws Exception {
		int column = 1;
		if (encrypt) {
			tableInfo.TABLE_TEXT.addEncryptText(tableId, String.format("%s.%s", table.getDatabase(), table.getTablename()));
			sheet.addCell(new Label(column++, beginRow, String.valueOf(tableId++), CELL_THIN));
		} else {
			sheet.addCell(new Label(column++, beginRow, table.getDatabase(), CELL_THIN));
			sheet.addCell(new Label(column++, beginRow, table.getTablename(), CELL_THIN));
		}
		sheet.addCell(new Label(column++, beginRow, table.getOwner(), CELL_THIN));
		sheet.addCell(new Label(column++, beginRow, String.valueOf(table.getSmallFileNumber()), CELL_THIN));
		sheet.addCell(new Label(column++, beginRow, table.getSmallFilePercent(), CELL_THIN));
		String comparisonResult = table.getFileComparison();
		String[] items = comparisonResult.split("\\|");
		for (String item : items) {
			sheet.addCell(new Label(column++, beginRow, item, CELL_THIN));
		}
	}
}
