package io.transwarp.table.text.servlet;

import java.util.Map;
import java.util.Map.Entry;

import io.transwarp.common.bean.table.TextTableBean;
import io.transwarp.common.util.MyThreadPool;
import io.transwarp.table.servlet.AbstractCheckOnDetail;

public class TextTableCheckOnDetail extends AbstractCheckOnDetail {

	private final String hdfsName;
	private final Map<String, TextTableBean> textTables;
	private final Map<String, TextTableBean> otherTables;
	
	public TextTableCheckOnDetail(final String hdfsName,
			final Map<String, TextTableBean> textTables,
			final Map<String, TextTableBean> otherTables) {
		this.hdfsName = hdfsName;
		this.textTables = textTables;
		this.otherTables = otherTables;
	}
	
	@Override
	public void addTableCheck() throws Exception {
		for (Entry<String, TextTableBean> entry : textTables.entrySet()) {
			TextTableBean table = entry.getValue();
			MyThreadPool.addNewThread(new TextTableCheckRunnable(hdfsName, table));
		}
		for (Entry<String, TextTableBean> entry : otherTables.entrySet()) {
			TextTableBean table = entry.getValue();
			MyThreadPool.addNewThread(new TextTableCheckRunnable(hdfsName, table));
		}
	}

}
