package io.transwarp.table.text.servlet;

import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.Queue;

import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.transwarp.common.GlobalArgs;
import io.transwarp.common.bean.table.TextTableBean;
import io.transwarp.common.util.AbstractRunnable;
import io.transwarp.common.util.HdfsConnUtils;
import io.transwarp.inspection.CheckItemEnum;

public class TextTableCheckRunnable extends AbstractRunnable {

	private final static Logger log = LoggerFactory.getLogger(TextTableCheckRunnable.class);
	private final TextTableBean table;
	private final HdfsConnUtils hdfsPool;
	private FileSystem fs;
	
	public TextTableCheckRunnable(final String hdfsName,
			final TextTableBean table) {
		this.hdfsPool = GlobalArgs.hdfsPools.get(hdfsName);
		this.table = table;
	}
	
	@Override
	public void startCheck() throws Exception {
		fs = hdfsPool.getHdfsConn();
		try {
			Queue<String> queue = new LinkedList<String>();
			queue.offer(table.getLocation());
			while (!queue.isEmpty()) {
				String path = queue.poll();
				FileStatus[] files = fs.listStatus(new Path(path));
				for (FileStatus file : files) {
					if (file.isDirectory()) {
						queue.offer(file.getPath().toString());
					} else {
						table.addDataFile(file.getLen());
					}
				}
			}
		} catch (FileNotFoundException e) {
			log.warn("no find table [{}] location path on hdfs [{}]", String.format("%s.%s", table.getDatabase(), table.getTablename()), table.getLocation());
		}
	}
	
	@Override
	public void dealWithError(Exception e) {
		String msg = String.format("check text table [%s.%s] is faild | %s", table.getDatabase(), table.getTablename(), e.getMessage());
		GlobalArgs.ERROR_INFO.add(msg);
		log.error(msg);
		e.printStackTrace();
	}
	
	@Override
	public void closeThread() {
		hdfsPool.closeHdfsConn(fs);
		GlobalArgs.timeStatisticses.get(CheckItemEnum.TABLE.name()).setEndTime();
	}
	
}
