# get FROM IMAGE
if [ ! -f Dockerfile.patch ]; then
  echo "Dockerfile.patch not exists"
  exit 1
fi

image_type=$(head -n1 Dockerfile.patch | awk -F"IMAGE=" '{print $2}')
hostname=$(hostname)
ori_image=$(docker images | grep "$image_type " | grep -v backup | grep $hostname)
if [ $(echo "$ori_image" | wc -l) != 1 ]; then
  echo "ERROR: more than one matched images!"
  echo "$ori_image"
  exit 2
fi

image_repository=$(echo $ori_image | awk '{print $1}')
image_tag=$(echo $ori_image | awk '{print $2}')
read -p "The base image is $image_repository:$image_tag, is it ok? [y/n] " isok

if [ x"$isok" != "xy" -a x"$isok" != "xyes" ]; then
  exit 3
fi

# backup old IMAGE
suffix=`date "+%Y%m%d%H%M%S"`
docker tag $image_repository:$image_tag $image_repository:${image_tag}-backup-${suffix}

# generate DockerFile
sed "/#IMAGE/a FROM ${image_repository}:${image_tag}" Dockerfile.patch > Dockerfile

# docker build
docker build -t ${image_repository}:${image_tag} .

# push image
docker push ${image_repository}:${image_tag}
